/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.JFancyButton;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.table.JXObservationTable;

public class JumpToRandomVideoFrameButton
extends JFancyButton {
    public JumpToRandomVideoFrameButton() {
        this.setAction((Action)new ActionAdapter(){

            public void doAction() {
                JumpToRandomVideoFrameButton.this.jump();
            }
        });
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/random_button.png")));
        this.setText("");
        this.setToolTipText("Jump to random video frame");
        StateLookup.videoArchiveProperty().addListener((obs, oldv, newv) -> this.setEnabled(this.checkEnabled()));
        this.setEnabled(this.checkEnabled());
    }

    private boolean checkEnabled() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        return videoArchive != null;
    }

    private void jump() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            ArrayList jumpableObservations = new ArrayList();
            for (VideoFrame vf : videoArchive.getVideoFrames()) {
                List observations = vf.getObservations();
                if (observations.size() != 1) continue;
                jumpableObservations.addAll(observations);
            }
            if (jumpableObservations.size() > 0) {
                Random random = new Random();
                int r = random.nextInt(jumpableObservations.size());
                Observation selectedObservation = (Observation)jumpableObservations.get(r);
                JXObservationTable myTable = (JXObservationTable)StateLookup.getObservationTable();
                myTable.setSelectedObservation(selectedObservation);
            }
        }
    }
}

