/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.JFancyButton;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.table.JXObservationTable;

public class JumpToLastImageButton
extends JFancyButton {
    Comparator<Observation> comparator = (a, b) -> b.getVideoFrame().getTimecode().compareTo(a.getVideoFrame().getTimecode());

    public JumpToLastImageButton() {
        this.setAction((Action)new ActionAdapter(){

            public void doAction() {
                JumpToLastImageButton.this.jump();
            }
        });
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/nav_left_blue.png")));
        this.setText("");
        this.setToolTipText("Jump to proceeding video frame");
        StateLookup.videoArchiveProperty().addListener((obs, oldv, newv) -> this.setEnabled(this.checkEnabled()));
        this.setEnabled(this.checkEnabled());
    }

    private void jump() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            String lastSelectedTimecode = StateLookup.getSelectedObservations().stream().map(obs -> obs.getVideoFrame().getTimecode()).distinct().sorted().reduce((a, b) -> b).orElse("99:99:99:99");
            ArrayList jumpableObservations = new ArrayList();
            for (VideoFrame vf : videoArchive.getVideoFrames()) {
                List observations;
                if (vf.getTimecode().compareTo(lastSelectedTimecode) >= 0 || (observations = vf.getObservations()).size() <= 0) continue;
                jumpableObservations.add(observations.get(0));
            }
            jumpableObservations.sort(this.comparator);
            if (jumpableObservations.size() > 0) {
                Observation selectedObservation = (Observation)jumpableObservations.get(0);
                JXObservationTable myTable = (JXObservationTable)StateLookup.getObservationTable();
                myTable.setSelectedObservation(selectedObservation);
            }
        }
    }

    private boolean checkEnabled() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        return videoArchive != null;
    }
}

