/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.mbari.swing.SwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.video.SwingImageCaptureAction;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.shared.ui.DoNothingAction;
import vars.shared.ui.FancyButton;

public class FrameCaptureButton
extends FancyButton {
    private static final Logger log = LoggerFactory.getLogger(FrameCaptureButton.class);
    private Action action;

    public FrameCaptureButton(ToolBelt toolBelt) {
        try {
            this.action = new SwingImageCaptureAction(toolBelt);
            this.setAction(this.action);
        }
        catch (Exception e) {
            this.action = new DoNothingAction();
            log.warn("Unable to set-up frame-grabbing. You may not have Quicktime installed.", (Throwable)e);
        }
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/fgbutton.png")));
        this.setToolTipText("Grab an image from the video-stream [" + SwingUtils.getKeyString((KeyStroke)((KeyStroke)this.getAction().getValue("AcceleratorKey"))) + "]");
        this.setText("");
        StateLookup.videoControllerProperty().addListener((obs, oldVal, newVal) -> this.setEnabled(this.checkEnable()));
        StateLookup.videoArchiveProperty().addListener((obs, oldVal, newVal) -> this.setEnabled(this.checkEnable()));
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> this.setEnabled(this.checkEnable()));
        this.setEnabled(this.checkEnable());
    }

    public boolean checkEnable() {
        VideoController videoController = StateLookup.getVideoController();
        boolean enabled = false;
        if (videoController != null) {
            ImageCaptureService ics = videoController.getImageCaptureService();
            VideoArchive videoArchive = StateLookup.getVideoArchive();
            UserAccount userAccount = StateLookup.getUserAccount();
            enabled = ics != null && videoArchive != null && userAccount != null;
        }
        return enabled;
    }
}

