/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.RemoveImageReferencesCmd;
import vars.shared.ui.FancyButton;

public class DeleteImageReferenceButton
extends FancyButton {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ToolBelt toolBelt;

    public DeleteImageReferenceButton(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.setToolTipText("Remove image-references from the selected observations");
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/rfgbutton_delete.png")));
        this.setEnabled(false);
        this.setText("");
        this.addActionListener(e -> this.deleteImageReference());
        StateLookup.selectedObservationsProperty().addListener((obsv, oldVal, newVal) -> {
            boolean enabled;
            UserAccount userAccount = StateLookup.getUserAccount();
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            boolean bl = enabled = userAccount != null && observations != null && observations.size() > 0;
            if (enabled) {
                Observation obs;
                Iterator<Observation> iterator = observations.iterator();
                while (iterator.hasNext() && !(enabled = (obs = iterator.next()).getVideoFrame().getCameraData().getImageReference() != null)) {
                }
            }
            this.setEnabled(enabled);
        });
    }

    private void deleteImageReference() {
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        int count = observations.size();
        Object[] options = new Object[]{"OK", "CANCEL"};
        int confirm = JOptionPane.showOptionDialog(StateLookup.getAnnotationFrame(), "Do you want to remove the image reference from " + count + " observation(s)?", "VARS - Confirm Delete", -1, 2, null, options, options[0]);
        if (confirm == 1) {
            return;
        }
        this.log.debug("Setting image references to " + observations.size() + " observations to null");
        RemoveImageReferencesCmd command = new RemoveImageReferencesCmd(new ArrayList<Observation>(observations));
        CommandEvent commandEvent = new CommandEvent(command);
        EventBus.publish((Object)commandEvent);
    }
}

