/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mbari.awt.event.ActionAdapter;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.annotation.ui.actions.AddNewRefNumPropAction;
import vars.annotation.ui.actions.IVideoArchiveProperty;

public class UpdateNewRefNumAction
extends ActionAdapter
implements IVideoArchiveProperty {
    private boolean needsUpdating = true;
    private final AnnotationDAOFactory annotationDAOFactory;
    private VideoArchive videoArchive;

    public UpdateNewRefNumAction(AnnotationDAOFactory annotationDAOFactory) {
        this.annotationDAOFactory = annotationDAOFactory;
        this.doAction();
    }

    public void doAction() {
        if (this.needsUpdating) {
            int refNum = 1;
            if (this.videoArchive != null) {
                VideoArchiveDAO dao = this.annotationDAOFactory.newVideoArchiveDAO();
                dao.startTransaction();
                Set refNums = dao.findAllLinkValues(this.videoArchive, "identity-reference");
                dao.endTransaction();
                if (refNums.size() != 0) {
                    HashSet<Integer> intValues = new HashSet<Integer>();
                    for (String s : refNums) {
                        try {
                            intValues.add(Integer.valueOf(s));
                        }
                        catch (Exception exception) {}
                    }
                    if (!intValues.isEmpty()) {
                        refNum = (Integer)Collections.max(intValues);
                        ++refNum;
                    }
                }
            }
            AddNewRefNumPropAction.setRefNumber(refNum);
            this.needsUpdating = false;
        }
    }

    @Override
    public VideoArchive getVideoArchive() {
        return this.videoArchive;
    }

    @Override
    public void setVideoArchive(VideoArchive newVideoArchive) {
        VideoArchiveSet newVas;
        VideoArchiveSet oldVas;
        this.needsUpdating = true;
        if (this.videoArchive != null && newVideoArchive != null && (oldVas = this.videoArchive.getVideoArchiveSet()).equals(newVas = newVideoArchive.getVideoArchiveSet())) {
            this.needsUpdating = false;
        }
        this.videoArchive = newVideoArchive;
    }
}

