/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.util.List;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;

public class OpenVideoArchiveUsingParamsAction
extends ActionAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String platform;
    private String postfix;
    private int seqNumber;
    private int tapeNumber;
    protected final AnnotationDAOFactory annotationDAOFactory;

    public OpenVideoArchiveUsingParamsAction(AnnotationDAOFactory annotationDAOFactory) {
        super("Open archive");
        this.annotationDAOFactory = annotationDAOFactory;
    }

    public void doAction() {
        if (this.platform != null) {
            String videoArchiveName = PersistenceController.makeVideoArchiveName(this.platform, this.seqNumber, this.tapeNumber, this.postfix);
            try {
                VideoArchiveDAO videoArchiveDAO = this.annotationDAOFactory.newVideoArchiveDAO();
                videoArchiveDAO.startTransaction();
                VideoArchive videoArchive = videoArchiveDAO.findOrCreateByParameters(this.platform, this.seqNumber, videoArchiveName);
                List videoFrames = videoArchive.getVideoFrames();
                int i = 0;
                for (VideoFrame videoFrame : videoFrames) {
                    videoFrame.getTimecode();
                    ++i;
                }
                this.log.debug("Loaded " + i + " videoFrame");
                videoArchiveDAO.endTransaction();
                EventBus.publish((Object)new VideoArchiveSelectedEvent((Object)null, videoArchive));
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public int getTapeNumber() {
        return this.tapeNumber;
    }

    public void setPlatform(String string) {
        this.platform = string;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public void setSeqNumber(int i) {
        this.seqNumber = i;
    }

    public void setTapeNumber(int i) {
        this.tapeNumber = i;
    }
}

