/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.awt.Toolkit;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.KeyStroke;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.time.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.UserAccount;
import vars.annotation.CameraDirections;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddObservationCmd;
import vars.avplayer.VideoController;

public final class NewObservationAction
extends ActionAdapter {
    private final Logger log;
    private String defaultConceptName;

    public NewObservationAction(final ToolBelt toolBelt) {
        block2: {
            this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            try {
                this.defaultConceptName = toolBelt.getAnnotationPersistenceService().findRootConcept().getPrimaryConceptName().getName();
            }
            catch (Exception e) {
                this.defaultConceptName = "object";
                if (!this.log.isWarnEnabled()) break block2;
                this.log.warn("Failed to lookup root concept from database", (Throwable)e);
            }
        }
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                block2: {
                    try {
                        NewObservationAction.this.defaultConceptName = toolBelt.getAnnotationPersistenceService().findRootConcept().getPrimaryConceptName().getName();
                    }
                    catch (Exception e) {
                        NewObservationAction.this.defaultConceptName = "object";
                        if (!NewObservationAction.this.log.isWarnEnabled()) break block2;
                        NewObservationAction.this.log.warn("Failed to lookup root concept from database", (Throwable)e);
                    }
                }
            }

            public void beforeClear(CacheClearedEvent evt) {
                NewObservationAction.this.defaultConceptName = "object";
            }
        });
        this.putValue("Name", "New video-frame");
        this.putValue("ActionCommandKey", "new video-frame");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public void doAction() {
        this.doAction(this.defaultConceptName);
    }

    public void doAction(String conceptName) {
        VideoController videoController = StateLookup.getVideoController();
        if (videoController != null) {
            try {
                Future videoIndexFuture = videoController.getVideoIndex();
                VideoIndex videoIndex = (VideoIndex)videoIndexFuture.get(3L, TimeUnit.SECONDS);
                Timecode timecode = videoIndex.getTimecode().orElse(Timecode.zero());
                this.doAction(conceptName, timecode.toString());
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
        }
    }

    public void doAction(String conceptName, String timecode) {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        VideoController videoController = StateLookup.getVideoController();
        if (videoArchive != null) {
            if (conceptName != null && timecode != null) {
                UserAccount userAccount = StateLookup.getUserAccount();
                String person = userAccount.getUserName();
                if (person == null) {
                    person = "default";
                }
                try {
                    Future videoIndexFuture = videoController.getVideoIndex();
                    VideoIndex videoIndex = StateLookup.getLastVideoIndex();
                    try {
                        videoIndex = (VideoIndex)videoIndexFuture.get(3L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException te) {
                        this.log.warn("Failed to connect to video device. Using a previously stored video index", (Throwable)te);
                    }
                    Date utcDate = videoIndex.getTimestamp().map(Date::from).orElse(new Date());
                    CameraDirections cameraDirections = StateLookup.getCameraDirection();
                    String cameraDirection = cameraDirections.getDirection();
                    AddObservationCmd command = new AddObservationCmd(conceptName, timecode, utcDate, videoArchive.getName(), person, cameraDirection, true);
                    CommandEvent commandEvent = new CommandEvent(command);
                    EventBus.publish((Object)commandEvent);
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
            } else {
                this.log.warn("Missing parameters needed to create new Observation");
            }
        } else {
            this.log.warn("A VideoArchive has no been assigned; unable to create a VideoFrame");
        }
    }
}

