/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.MoveVideoFramesCmd;
import vars.annotation.ui.dialogs.OpenVideoArchiveDialog;

public class MoveVideoFrameWithDialogAction
extends ActionAdapter {
    public static final String ACTION_NAME = "Move Frames";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final OpenVideoArchiveDialog dialog;
    private Collection<VideoFrame> videoFrames = new ArrayList<VideoFrame>();

    public MoveVideoFrameWithDialogAction(Frame owner, ToolBelt toolBelt) {
        this(owner, toolBelt, false);
    }

    public MoveVideoFrameWithDialogAction(Frame owner, ToolBelt toolBelt, final boolean refreshVideoFrame) {
        super(ACTION_NAME);
        this.dialog = new OpenVideoArchiveDialog(owner, toolBelt);
        this.dialog.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoArchive videoArchive = MoveVideoFrameWithDialogAction.this.dialog.openVideoArchive();
                MoveVideoFramesCmd command = new MoveVideoFramesCmd(videoArchive.getName(), MoveVideoFrameWithDialogAction.this.videoFrames, refreshVideoFrame);
                CommandEvent commandEvent = new CommandEvent(command);
                MoveVideoFrameWithDialogAction.this.dialog.dispose();
                EventBus.publish((Object)commandEvent);
            }
        });
    }

    public void doAction() {
        this.dialog.setVisible(true);
    }

    public void setVideoFrames(Collection<VideoFrame> videoFrames) {
        this.videoFrames.clear();
        this.videoFrames.addAll(videoFrames);
    }
}

