/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.awt.Toolkit;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.KeyStroke;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.vcr4j.VideoIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.CopyObservationsCmd;
import vars.avplayer.VideoController;

public final class DeepCopyObservationsAction
extends ActionAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ToolBelt toolBelt;

    public DeepCopyObservationsAction(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.putValue("Name", "Copy observations to a new timecode");
        this.putValue("ActionCommandKey", "copy observations");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public void doAction() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        VideoController videoController = StateLookup.getVideoController();
        if (videoArchive != null && videoController != null) {
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            if (observations.size() == 0) {
                return;
            }
            try {
                Future videoIndexFuture = videoController.getVideoIndex();
                VideoIndex videoIndex = (VideoIndex)videoIndexFuture.get(3L, TimeUnit.SECONDS);
                UserAccount userAccount = StateLookup.getUserAccount();
                String user = userAccount != null ? userAccount.getUserName() : "default";
                CopyObservationsCmd command = new CopyObservationsCmd(videoArchive.getName(), videoIndex, user, observations, true);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("Timed-out waiting for videoindex from " + videoController));
            }
        } else {
            this.log.warn("Missing either a VideoArchive or a VideoControlService; unable to copy observations");
        }
    }
}

