/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.PersistenceCache;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;

public class ClearDatabaseCacheAction
extends ActionAdapter {
    public static final String ACTION_NAME = "Refresh Data";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ToolBelt toolBelt;

    public ClearDatabaseCacheAction(ToolBelt toolBelt) {
        super(ACTION_NAME);
        this.toolBelt = toolBelt;
    }

    public void doAction() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        final String name = videoArchive == null ? null : videoArchive.getName();
        StateLookup.setVideoArchive(null);
        final PersistenceCache persistenceCache = this.toolBelt.getPersistenceCache();
        CacheClearedListener listener = new CacheClearedListener(){

            public void beforeClear(CacheClearedEvent evt) {
            }

            public void afterClear(CacheClearedEvent evt) {
                try {
                    if (name != null) {
                        Thread thread = new Thread(() -> {
                            VideoArchiveDAO dao = ClearDatabaseCacheAction.this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
                            dao.startTransaction();
                            VideoArchive refreshedVideoArchive = dao.findByName(name);
                            dao.endTransaction();
                            dao.close();
                            EventBus.publish((Object)new VideoArchiveSelectedEvent((Object)null, refreshedVideoArchive));
                        }, "Clear cache thread");
                        thread.start();
                    }
                    persistenceCache.removeCacheClearedListener((CacheClearedListener)this);
                }
                catch (Exception e) {
                    ClearDatabaseCacheAction.this.log.error("Failed to refresh the knowledgbase", (Throwable)e);
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (Object)e);
                }
            }
        };
        persistenceCache.addCacheClearedListener(listener);
        persistenceCache.clear();
    }
}

