/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import org.bushe.swing.event.EventBus;
import vars.annotation.VideoArchive;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.OpenVideoArchiveUsingParamsAction;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangeVideoArchiveNameCmd;

public class ChangeVideoArchiveNameAction
extends OpenVideoArchiveUsingParamsAction {
    private final ToolBelt toolBelt;

    public ChangeVideoArchiveNameAction(ToolBelt toolBelt) {
        super(toolBelt.getAnnotationDAOFactory());
        this.toolBelt = toolBelt;
    }

    @Override
    public void doAction() {
        if (!this.verifyParams()) {
            return;
        }
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        String newName = PersistenceController.makeVideoArchiveName(this.getPlatform(), this.getSeqNumber(), this.getTapeNumber(), this.getPostfix());
        ChangeVideoArchiveNameCmd command = new ChangeVideoArchiveNameCmd(videoArchive, newName, this.getPlatform(), this.getSeqNumber());
        CommandEvent commandEvent = new CommandEvent(command);
        EventBus.publish((Object)commandEvent);
    }

    private boolean verifyParams() {
        boolean ok = true;
        String p = this.getPlatform();
        int sn = this.getSeqNumber();
        int tn = this.getTapeNumber();
        if (p == null || sn == 0 || tn == 0) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Some of the information required to carry out this action is missing. You're request is being ignored.");
            ok = false;
        }
        return ok;
    }
}

