/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.util.Collection;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddAssociationCmd;

public class AddPropertyAction
extends ActionAdapter {
    public static final String NIL = "nil";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String linkName;
    private String linkValue;
    private String toConcept;
    private final ToolBelt toolBelt;

    public AddPropertyAction(ToolBelt toolBelt) {
        this(toolBelt, NIL, NIL, NIL);
    }

    public AddPropertyAction(ToolBelt toolBelt, String linkName, String toConcept, String linkValue) {
        this.toolBelt = toolBelt;
        this.setLinkName(linkName);
        this.setToConcept(toConcept);
        this.setLinkValue(linkValue);
    }

    public void doAction() {
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        Association associationTemplate = this.toolBelt.getAnnotationFactory().newAssociation(this.linkName, this.toConcept, this.linkValue);
        AddAssociationCmd command = new AddAssociationCmd((ILink)associationTemplate, observations);
        CommandEvent commandEvent = new CommandEvent(command);
        EventBus.publish((Object)commandEvent);
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getLinkValue() {
        return this.linkValue;
    }

    public String getToConcept() {
        return this.toConcept;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setLinkValue(String linkValue) {
        this.linkValue = linkValue;
    }

    public void setToConcept(String toConcept) {
        this.toConcept = toConcept;
    }
}

