/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.awt.event.IAction;
import org.mbari.text.ReverseSortComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.AddOldRefNumPropAction;
import vars.knowledgebase.Concept;

public class AddOldRefNumPropWithDialogAction
extends ActionAdapter {
    private static final Comparator COMPARATOR = new ReverseSortComparator();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final IAction action;
    private final ToolBelt toolBelt;

    public AddOldRefNumPropWithDialogAction(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.action = new AddOldRefNumPropAction(toolBelt);
    }

    public void doAction() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive == null) {
            return;
        }
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        if (observations.size() == 0) {
            return;
        }
        String conceptName = observations.iterator().next().getConceptName();
        for (Observation observation : observations) {
            if (observation.getConceptName().equals(conceptName)) continue;
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"The selected observations must all contain the same conceptname");
            return;
        }
        VideoArchiveSet vas = videoArchive.getVideoArchiveSet();
        Concept concept = null;
        Collection refNums = new TreeSet();
        try {
            AnnotationPersistenceService service = this.toolBelt.getAnnotationPersistenceService();
            concept = service.findConceptByName(conceptName);
            refNums = service.findAllReferenceNumbers(vas, concept);
        }
        catch (Exception e) {
            this.log.error("Failed to lookup a concept in the knowledebase", (Throwable)e);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            return;
        }
        if (refNums.size() == 0) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("<html><body>No reference numbers for " + conceptName + " were found. Use 'New #' instead.</body></html>"));
        } else {
            Object[] choices = refNums.toArray(new String[refNums.size()]);
            Arrays.sort(choices, COMPARATOR);
            String i = (String)JOptionPane.showInputDialog(StateLookup.getAnnotationFrame(), "Select a reference number", "VARS - Select Reference Number", -1, null, choices, choices[0]);
            if (i != null) {
                AddOldRefNumPropAction.setRefNumber(i);
                this.action.doAction();
            }
        }
    }
}

