/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.mbari.swing.SwingUtils;
import org.mbari.util.Tuple2;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.StatusLabel;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.VideoPlayers;
import vars.shared.rx.RXEventBus;

public class VideoPlayersPanel
extends JPanel {
    private JComboBox<VideoPlayer> videoPlayerComboBox;
    private final vars.annotation.ui.ToolBelt toolBelt;
    private final RXEventBus eventBus;
    private VideoLabel videoLabel;

    public VideoPlayersPanel(vars.annotation.ui.ToolBelt toolBelt, RXEventBus eventBus) {
        this.toolBelt = toolBelt;
        this.eventBus = eventBus;
        this.setLayout(new BoxLayout(this, 0));
        this.initialize();
    }

    protected void initialize() {
        this.add(new JLabel("Video Device:"));
        this.add(Box.createHorizontalStrut(10));
        this.add(this.getVideoPlayerComboBox());
        this.add(Box.createHorizontalStrut(10));
        this.add(this.getVideoLabel());
        StateLookup.videoControllerProperty().addListener((obs, oldVal, newVal) -> this.getVideoLabel().updateLabel(StateLookup.getVideoArchive(), (VideoController)newVal));
        StateLookup.videoArchiveProperty().addListener((obs, oldVal, newVal) -> this.getVideoLabel().updateLabel((VideoArchive)newVal, StateLookup.getVideoController()));
    }

    private JComboBox<VideoPlayer> getVideoPlayerComboBox() {
        if (this.videoPlayerComboBox == null) {
            Vector videoPlayers = new Vector(VideoPlayers.get());
            this.videoPlayerComboBox = new JComboBox(videoPlayers);
            this.videoPlayerComboBox.setRenderer(new VideoPlayerRenderer());
            Dimension d = this.videoPlayerComboBox.getPreferredSize();
            this.videoPlayerComboBox.setPreferredSize(new Dimension(150, d.height));
        }
        return this.videoPlayerComboBox;
    }

    public VideoPlayer getSelectedVideoPlayer() {
        return (VideoPlayer)this.getVideoPlayerComboBox().getSelectedItem();
    }

    private VideoLabel getVideoLabel() {
        if (this.videoLabel == null) {
            this.videoLabel = new VideoLabel();
            Dimension d = this.videoLabel.getPreferredSize();
            this.videoLabel.setPreferredSize(new Dimension(400, d.height));
        }
        return this.videoLabel;
    }

    class VideoLabel
    extends StatusLabel {
        public VideoLabel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    SwingUtils.flashJComponent((JComponent)VideoLabel.this, (int)2);
                    VideoPlayerDialogUI dialog = VideoPlayersPanel.this.getSelectedVideoPlayer().getConnectionDialog((ToolBelt)VideoPlayersPanel.this.toolBelt, VideoPlayersPanel.this.eventBus);
                    Point locationOnScreen = VideoLabel.this.getLocationOnScreen();
                    dialog.setLocation(locationOnScreen.x, locationOnScreen.y);
                    dialog.setVisible(true);
                }
            });
            AnnotationProcessor.process((Object)this);
            this.updateLabel(StateLookup.getVideoArchive(), StateLookup.getVideoController());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateLabel((VideoArchive)evt.getNewValue(), StateLookup.getVideoController());
        }

        public Tuple2<String, String> buildLabel(VideoArchive videoArchive, VideoController videoController) {
            String[] parts;
            String videoPart;
            String toolTip = videoPart = videoArchive == null ? "NONE" : videoArchive.getName();
            if (videoPart.length() > 20 && (videoPart.toLowerCase().startsWith("http:") || videoPart.toLowerCase().startsWith("file:")) && (parts = videoPart.split("/")).length > 0) {
                videoPart = ".../" + parts[parts.length - 1];
            }
            String connectionID = videoController != null ? " @ " + videoController.getConnectionID() : "";
            String text = videoPart + connectionID;
            text = "Video: " + text;
            toolTip = toolTip + connectionID;
            return new Tuple2((Object)toolTip, (Object)text);
        }

        public void updateLabel(VideoArchive videoArchive, VideoController videoController) {
            boolean ok = videoArchive != null;
            Tuple2<String, String> txt = this.buildLabel(videoArchive, videoController);
            String text = (String)txt.getB();
            String toolTip = (String)txt.getA();
            this.setText(text);
            this.setToolTipText(toolTip);
            this.setOk(ok);
        }
    }

    class VideoPlayerRenderer
    extends JLabel
    implements ListCellRenderer<VideoPlayer> {
        VideoPlayerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends VideoPlayer> list, VideoPlayer value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value.getName());
            return this;
        }
    }
}

