/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VARSProperties {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("annotation-app", Locale.US);
    private static Map<String, String> platforms;
    private static final Logger log;
    private static String deploymentLocale;
    private static String imageCopyrightOwner;
    private static String vcrUrl;
    private static int vcrPort;
    private static String imageArchiveDirectory;
    private static String imageArchiveURL;
    private static boolean showRecordedDateInTable;

    private VARSProperties() {
    }

    private static String getProperty(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            property = bundle.getString(key);
        }
        if (log.isDebugEnabled()) {
            log.debug("VARS Property found: " + key + " = " + property);
        }
        return property;
    }

    public static Collection<String> getCameraPlatforms() {
        return platforms.keySet();
    }

    public static Collection getShips() {
        return platforms.values();
    }

    public static String getShip(String cameraPlatform) {
        return platforms.get(cameraPlatform);
    }

    public static String getCameraPlatform(String ship) {
        String cameraPlatform;
        block1: {
            String matchingShip;
            cameraPlatform = null;
            if (ship == null) break block1;
            Iterator<String> i = platforms.keySet().iterator();
            while (i.hasNext() && !ship.equals(matchingShip = platforms.get(cameraPlatform = i.next()))) {
            }
        }
        return cameraPlatform;
    }

    public static String getDeploymentLocale() {
        return deploymentLocale;
    }

    public static String getImageCopyrightOwner() {
        return imageCopyrightOwner;
    }

    public static int getVcrPort() {
        return vcrPort;
    }

    public static String getVcrUrl() {
        return vcrUrl;
    }

    public static String getImageArchiveURL() {
        return imageArchiveURL;
    }

    public static String getImageArchiveDirectory() {
        return imageArchiveDirectory;
    }

    public static boolean getShowRecordedDateInTable() {
        return showRecordedDateInTable;
    }

    static {
        log = LoggerFactory.getLogger(VARSProperties.class);
        platforms = new HashMap<String, String>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith("cameraplatform")) continue;
            String cameraPlatform = bundle.getString(key);
            log.debug("Found Camera platform: " + key + " = " + cameraPlatform);
            String idx = key.substring(key.indexOf("."));
            String shipKey = "ship" + idx;
            String ship = "";
            try {
                log.debug("Looking for " + shipKey + " in " + "annotation-app");
                ship = bundle.getString(shipKey);
            }
            catch (MissingResourceException e) {
                log.info("Failed to find key '" + shipKey + "' in " + "annotation-app");
                ship = cameraPlatform;
            }
            platforms.put(cameraPlatform, ship);
        }
        try {
            deploymentLocale = VARSProperties.getProperty("deployment.locale");
        }
        catch (MissingResourceException e) {
            log.info("The property 'deployment.locale' was not found in annotation-app");
            deploymentLocale = null;
        }
        try {
            imageCopyrightOwner = VARSProperties.getProperty("image.copyright.owner");
        }
        catch (MissingResourceException e) {
            log.info("The property 'image.copyright.owner' was not found in annotation-app");
            imageCopyrightOwner = "";
        }
        try {
            String vcrLocation = VARSProperties.getProperty("vcr.url");
            int i = vcrLocation.indexOf(":");
            vcrUrl = vcrLocation.substring(0, i);
            vcrPort = i > -1 ? Integer.parseInt(vcrLocation.substring(i + 1, vcrLocation.length())) : 9000;
        }
        catch (MissingResourceException e) {
            log.info("The property 'vcr.url' was not found in annotation-app");
            vcrUrl = null;
            vcrPort = -1;
        }
        try {
            imageArchiveDirectory = VARSProperties.getProperty("image.archive.dir");
        }
        catch (MissingResourceException e) {
            log.info("The property 'image.archive.dir' was not found in annotation-app");
        }
        try {
            imageArchiveURL = VARSProperties.getProperty("image.archive.url");
        }
        catch (MissingResourceException e) {
            log.info("The property 'image.archive.url' was not found in annotation-app");
        }
        try {
            showRecordedDateInTable = Boolean.parseBoolean(VARSProperties.getProperty("show.recorded.date"));
        }
        catch (MissingResourceException e) {
            log.info("The property 'show.recorded.date' was not found in annotation-app");
        }
        catch (Exception e) {
            log.info("Expected 'true' or 'false' for 'show.recorded.date in annotation-app but found " + VARSProperties.getProperty("show.recorded.date"));
        }
    }
}

