/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.mbari.swing.SwingUtils;
import vars.UserAccount;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.StatusLabel;
import vars.annotation.ui.ToolBelt;
import vars.shared.ui.dialogs.LoginAction;
import vars.shared.ui.dialogs.LoginDialog;

public class StatusLabelForPerson
extends StatusLabel {
    private final LoginAction action;

    public StatusLabelForPerson(ToolBelt toolBelt) {
        this.action = new LoginAction(toolBelt.getMiscDAOFactory(), toolBelt.getMiscFactory(), false);
        UserAccount userAccount = StateLookup.getUserAccount();
        this.update(userAccount);
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> this.update((UserAccount)newVal));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                LoginDialog userDialog = StatusLabelForPerson.this.action.getDialog();
                Point mousePosition = me.getPoint();
                SwingUtilities.convertPointToScreen(mousePosition, StatusLabelForPerson.this);
                int x = mousePosition.x;
                int y = mousePosition.y - userDialog.getHeight();
                if (x < 1) {
                    x = 1;
                }
                if (y < 1) {
                    y = 1;
                }
                userDialog.setLocation(x, y);
                SwingUtils.flashJComponent((JComponent)StatusLabelForPerson.this, (int)2);
                StatusLabelForPerson.this.action.doAction();
            }
        });
    }

    public void update(UserAccount userAccount) {
        boolean ok = true;
        String msg = "User: Not logged in";
        if (userAccount == null) {
            ok = false;
        } else {
            msg = "User: " + userAccount.getUserName();
        }
        this.setText(msg);
        this.setOk(ok);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update((UserAccount)evt.getNewValue());
    }
}

