/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.SwingUtils;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.StatusLabel;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.VideoPlayers;
import vars.avplayer.noop.NoopVideoPlayer;
import vars.shared.rx.RXEventBus;

public class StatusContainerForVideoPlayer
extends JPanel {
    private static final String NO_FILE = "Video: None Selected";
    private JComboBox<String> videoPlayerComboBox;
    private StatusLabel statusLabel;
    private List<VideoPlayer> videoPlayers;
    private final vars.annotation.ui.ToolBelt toolBelt;
    private final RXEventBus eventBus;

    public StatusContainerForVideoPlayer(vars.annotation.ui.ToolBelt toolBelt, RXEventBus eventBus) {
        this.toolBelt = toolBelt;
        this.eventBus = eventBus;
        this.setLayout(new BoxLayout(this, 0));
        this.videoPlayers = VideoPlayers.get();
        this.statusLabel = new StatusLabelForVideoPlayer(toolBelt);
        this.add(new JLabel("Video Device:"));
        this.add(Box.createHorizontalStrut(20));
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(20));
        this.add(new JLabel("Video Player:"));
        this.add(this.getVideoPlayerComboBox());
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        this.update(videoArchive);
        AnnotationProcessor.process((Object)this);
    }

    private JComboBox<String> getVideoPlayerComboBox() {
        if (this.videoPlayerComboBox == null) {
            this.videoPlayerComboBox = new JComboBox();
            for (VideoPlayer v : this.videoPlayers) {
                this.videoPlayerComboBox.addItem(v.getName());
            }
            Dimension d = this.videoPlayerComboBox.getPreferredSize();
            this.videoPlayerComboBox.setPreferredSize(new Dimension(200, d.height));
        }
        return this.videoPlayerComboBox;
    }

    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        this.update((VideoArchive)event.get());
    }

    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.update((VideoArchive)event.get());
    }

    public void update(VideoArchive videoArchive) {
        String text;
        boolean ok = false;
        String toolTip = text = "NONE";
        if (videoArchive != null) {
            String[] parts;
            toolTip = text = videoArchive.getName() + "";
            if (text.length() > 20 && (text.toLowerCase().startsWith("http:") || text.toLowerCase().startsWith("file:")) && (parts = text.split("/")).length > 0) {
                text = ".../" + parts[parts.length - 1];
            }
            ok = true;
        }
        this.statusLabel.setText("Video: " + text);
        this.setToolTipText(toolTip);
        this.statusLabel.setOk(ok);
    }

    VideoPlayer getSelectedVideoPlayer() {
        JComboBox<String> cb = this.getVideoPlayerComboBox();
        String name = cb.getItemAt(cb.getSelectedIndex());
        Optional<VideoPlayer> videoPlayer = this.videoPlayers.stream().filter(v -> v.getName().equals(name)).findFirst();
        return videoPlayer.orElse((VideoPlayer)new NoopVideoPlayer());
    }

    class StatusLabelForVideoPlayer
    extends StatusLabel {
        StatusLabelForVideoPlayer(final vars.annotation.ui.ToolBelt toolBelt) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    int y;
                    SwingUtils.flashJComponent((JComponent)StatusLabelForVideoPlayer.this, (int)2);
                    Point mousePosition = me.getPoint();
                    SwingUtilities.convertPointToScreen(mousePosition, StatusLabelForVideoPlayer.this);
                    VideoPlayer videoPlayer = StatusContainerForVideoPlayer.this.getSelectedVideoPlayer();
                    VideoPlayerDialogUI dialog = videoPlayer.getConnectionDialog((ToolBelt)toolBelt, StatusContainerForVideoPlayer.this.eventBus);
                    int x = mousePosition.x;
                    if (x < 1) {
                        x = 1;
                    }
                    if ((y = mousePosition.y - dialog.getHeight()) < 1) {
                        y = 1;
                    }
                    dialog.setLocation(x, y);
                    dialog.setVisible(true);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StatusContainerForVideoPlayer.this.update((VideoArchive)evt.getNewValue());
        }
    }
}

