/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import rx.Subscriber;
import vars.VarsUserPreferencesFactory;
import vars.annotation.CameraDirections;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.ui.AnnotationFrame;
import vars.annotation.ui.App;
import vars.annotation.ui.InjectorModule;
import vars.annotation.ui.table.ObservationTable;
import vars.avplayer.VideoController;
import vars.shared.ui.GlobalStateLookup;

public class StateLookup
extends GlobalStateLookup {
    public static final String RESOURCE_BUNDLE = "annotation-app";
    public static final String TOPIC_DATABASE_STATUS = "vars.annotation.ui.StateLookup-DatabaseStatus";
    public static final String TOPIC_REFRESH = "vars.annotation.ui.StateLookup-Refresh";
    public static final String TOPIC_SELECT_CONCEPT = "vars-annotation.ui.StateLookup-SelectedConcept";
    private static final ObjectProperty<CameraDirections> cameraDirection = new SimpleObjectProperty();
    public static final Injector GUICE_INJECTOR = Guice.createInjector((Module[])new Module[]{new InjectorModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
    private static final ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController = new SimpleObjectProperty();
    private static final ObjectProperty<ObservationTable> observationTable = new SimpleObjectProperty();
    private static final ObjectProperty<Preferences> preferences = new SimpleObjectProperty();
    private static final ObjectProperty<VideoIndex> lastVideoIndex = new SimpleObjectProperty();
    private static final ObjectProperty<VideoArchive> videoArchive = new SimpleObjectProperty();
    private static final ObjectProperty<Collection<Observation>> selectedObservations = new SimpleObjectProperty(new ArrayList());
    private static AnnotationFrame annotationFrame;
    private static App app;
    public static PreferencesFactory PREFERENCES_FACTORY;

    public static VideoArchive getVideoArchive() {
        return (VideoArchive)videoArchive.get();
    }

    public static ObjectProperty<VideoArchive> videoArchiveProperty() {
        return videoArchive;
    }

    public static void setVideoArchive(VideoArchive videoArchive) {
        StateLookup.videoArchive.set((Object)videoArchive);
    }

    public static void setCameraDirection(CameraDirections cd) {
        cameraDirection.set((Object)cd);
    }

    public static CameraDirections getCameraDirection() {
        return (CameraDirections)cameraDirection.get();
    }

    public static ObjectProperty<CameraDirections> cameraDirectionProperty() {
        return cameraDirection;
    }

    public Injector getInjector() {
        return GUICE_INJECTOR;
    }

    public static VideoController getVideoController() {
        return (VideoController)videoController.get();
    }

    public static ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoControllerProperty() {
        return videoController;
    }

    public static void setVideoController(VideoController<? extends VideoState, ? extends VideoError> videoController) {
        StateLookup.videoController.set(videoController);
    }

    public static ObservationTable getObservationTable() {
        return (ObservationTable)observationTable.get();
    }

    public static ObjectProperty<ObservationTable> observationTableProperty() {
        return observationTable;
    }

    public static void setObservationTable(ObservationTable observationTable) {
        StateLookup.observationTable.set((Object)observationTable);
    }

    public static Preferences getPreferences() {
        return (Preferences)preferences.get();
    }

    public static ObjectProperty<Preferences> preferencesProperty() {
        return preferences;
    }

    public static void setPreferences(Preferences preferences) {
        StateLookup.preferences.set((Object)preferences);
    }

    public static Collection<Observation> getSelectedObservations() {
        Collection obs = (Collection)selectedObservations.get();
        if (obs == null || obs.isEmpty()) {
            return new ArrayList<Observation>();
        }
        return new ArrayList<Observation>(obs);
    }

    public static ObjectProperty<Collection<Observation>> selectedObservationsProperty() {
        return selectedObservations;
    }

    public static void setSelectedObservations(Collection<Observation> selectedObservations) {
        selectedObservations = selectedObservations == null ? new ArrayList<Observation>() : new ArrayList<Observation>(selectedObservations);
        StateLookup.selectedObservations.set(selectedObservations);
    }

    public static AnnotationFrame getAnnotationFrame() {
        return annotationFrame;
    }

    public static void setAnnotationFrame(AnnotationFrame annotationFrame) {
        StateLookup.annotationFrame = annotationFrame;
    }

    public static App getApp() {
        return app;
    }

    public static void setApp(App app) {
        StateLookup.app = app;
    }

    public static VideoIndex getLastVideoIndex() {
        return (VideoIndex)lastVideoIndex.get();
    }

    public static ObjectProperty<VideoIndex> lastVideoIndexProperty() {
        return lastVideoIndex;
    }

    public static void setLastVideoIndex(VideoIndex lastVideoIndex) {
        StateLookup.lastVideoIndex.set((Object)lastVideoIndex);
    }

    private static Subscriber<VideoIndex> newIndexSubscriber() {
        return new Subscriber<VideoIndex>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(VideoIndex videoIndex) {
                lastVideoIndex.set((Object)videoIndex);
            }
        };
    }

    static {
        PREFERENCES_FACTORY = (PreferencesFactory)GUICE_INJECTOR.getInstance(PreferencesFactory.class);
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
            Preferences prefs = null;
            if (newVal != null) {
                VarsUserPreferencesFactory factory = (VarsUserPreferencesFactory)GUICE_INJECTOR.getInstance(VarsUserPreferencesFactory.class);
                prefs = factory.userRoot(newVal.getUserName());
            }
            preferences.set(prefs);
        });
        videoController.addListener((obs, oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.close();
            }
            if (newVal != null) {
                newVal.getIndexObservable().subscribe(StateLookup.newIndexSubscriber());
            }
        });
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal == null) {
                StateLookup.setPreferences(null);
            } else {
                VarsUserPreferencesFactory factory = (VarsUserPreferencesFactory)GUICE_INJECTOR.getInstance(VarsUserPreferencesFactory.class);
                Preferences prefs = factory.userRoot(newVal.getUserName());
                StateLookup.setPreferences(prefs);
            }
        });
        EventBus.subscribe((String)TOPIC_REFRESH, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_DATABASE_STATUS, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
    }
}

