/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import vars.annotation.CameraDirections;
import vars.annotation.FormatCodes;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.CameraDirectionComboBox;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.ChangeAnnotationModeAction;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangeCameraDirectionsCmd;

public class QuickControlsPanel
extends JPanel {
    private final ChangeAnnotationModeAction action;
    private JLabel cameraLabel;
    private JComboBox cbCameraDirection;
    private JComboBox modeChoiceBox;
    private JLabel modeLabel;
    private ModeObject[] modeObjects;

    public QuickControlsPanel(ToolBelt toolBelt) {
        this.action = new ChangeAnnotationModeAction(toolBelt);
        this.initialize();
    }

    private JLabel getCameraLabel() {
        if (this.cameraLabel == null) {
            this.cameraLabel = new JLabel();
            this.cameraLabel.setText(" Camera Direction: ");
        }
        return this.cameraLabel;
    }

    private JComboBox getCbCameraDirection() {
        if (this.cbCameraDirection == null) {
            this.cbCameraDirection = new CameraDirectionComboBox();
            this.cbCameraDirection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Collection<Observation> observations = StateLookup.getSelectedObservations();
                        HashSet<VideoFrame> videoFrames = new HashSet<VideoFrame>();
                        for (Observation observation : observations) {
                            videoFrames.add(observation.getVideoFrame());
                        }
                        if (videoFrames.size() > 0) {
                            CameraDirections cameraDirections = (CameraDirections)QuickControlsPanel.this.cbCameraDirection.getSelectedItem();
                            String cameraDirection = cameraDirections.getDirection();
                            ChangeCameraDirectionsCmd command = new ChangeCameraDirectionsCmd(cameraDirection, videoFrames);
                            CommandEvent commandEvent = new CommandEvent(command);
                            EventBus.publish((Object)commandEvent);
                        }
                        StateLookup.setCameraDirection((CameraDirections)QuickControlsPanel.this.cbCameraDirection.getSelectedItem());
                    }
                }
            });
            this.cbCameraDirection.setSelectedItem(CameraDirections.DESCEND);
            StateLookup.setCameraDirection((CameraDirections)this.cbCameraDirection.getSelectedItem());
        }
        return this.cbCameraDirection;
    }

    private JComboBox getModeChoiceBox() {
        if (this.modeChoiceBox == null) {
            this.modeChoiceBox = new ModeComboBox();
        }
        return this.modeChoiceBox;
    }

    private JLabel getModeLabel() {
        if (this.modeLabel == null) {
            this.modeLabel = new JLabel();
            this.modeLabel.setText(" Annotation Mode: ");
        }
        return this.modeLabel;
    }

    public ModeObject[] getModeObjects() {
        if (this.modeObjects == null) {
            this.modeObjects = new ModeObject[]{new ModeObject(FormatCodes.OUTLINE.getCode()), new ModeObject(FormatCodes.DETAILED.getCode())};
        }
        return this.modeObjects;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.getModeLabel(), null);
        this.add((Component)this.getModeChoiceBox(), null);
        this.add((Component)this.getCameraLabel(), null);
        this.add((Component)this.getCbCameraDirection(), null);
        this.getModeChoiceBox();
    }

    class ModeObject {
        private final char code;
        private final String codeString;

        ModeObject(char c) {
            this.code = c;
            this.codeString = FormatCodes.getDescriptiveName((String)(c + ""));
        }

        public boolean equals(Object obj) {
            boolean ok = false;
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                ok = false;
            } else if (obj == this) {
                ok = true;
            } else {
                ModeObject that = (ModeObject)obj;
                if (this.code == that.code) {
                    ok = true;
                }
            }
            return ok;
        }

        public String toString() {
            return this.codeString;
        }
    }

    class ModeComboBox
    extends JComboBox
    implements PropertyChangeListener {
        ModeComboBox() {
            this.initialize();
        }

        void initialize() {
            this.setEditable(false);
            this.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.setMaximumRowCount(5);
            this.setName("Annotation Mode");
            ModeObject[] mos = QuickControlsPanel.this.getModeObjects();
            for (int i = 0; i < mos.length; ++i) {
                this.addItem(mos[i]);
            }
            this.setPreferredSize(new Dimension(120, 25));
            this.addActionListener(e -> {
                Object selectedItem = this.getSelectedItem();
                if (!(selectedItem instanceof ModeObject)) {
                    return;
                }
                ModeObject mode = (ModeObject)QuickControlsPanel.this.modeChoiceBox.getSelectedItem();
                QuickControlsPanel.this.action.setFormatCode(mode.code);
                QuickControlsPanel.this.action.doAction();
            });
            StateLookup.videoArchiveProperty().addListener((obs, oldVal, newVal) -> {
                if (newVal != null) {
                    char formatCode = newVal.getVideoArchiveSet().getFormatCode();
                    ModeObject[] modes = QuickControlsPanel.this.getModeObjects();
                    for (int i = 0; i < modes.length; ++i) {
                        if (modes[i].code != formatCode) continue;
                        JComboBox cb = QuickControlsPanel.this.getModeChoiceBox();
                        ModeObject mo = (ModeObject)cb.getSelectedItem();
                        if (mo != null && !mo.equals(modes[i])) {
                            cb.setSelectedItem(modes[i]);
                        }
                        return;
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

