/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.mbari.net.URLUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.Association;
import vars.annotation.AssociationDAO;
import vars.annotation.CameraData;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;

public class PersistenceController {
    private static final NumberFormat f0123 = new DecimalFormat("0000");
    private static final NumberFormat f01 = new DecimalFormat("00");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AnnotationDAOFactory annotationDAOFactory;
    private final AnnotationFactory annotationFactory;
    private final ToolBelt toolBelt;

    public PersistenceController(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.annotationDAOFactory = toolBelt.getAnnotationDAOFactory();
        this.annotationFactory = toolBelt.getAnnotationFactory();
    }

    URL fileToUrl(File targetFile, File imageTarget, URL imageTargetMapping) throws IllegalArgumentException, MalformedURLException {
        URL out;
        block6: {
            String rootPath;
            String targetPath = targetFile.getAbsolutePath();
            if (!targetPath.startsWith(rootPath = imageTarget.getAbsolutePath())) {
                throw new IllegalArgumentException("The file, " + targetPath + ", is not located in the expected location, " + rootPath);
            }
            String postfix = targetPath.substring(rootPath.length(), targetPath.length());
            String[] parts = postfix.split("[\\\\\\\\,/]");
            StringBuffer dstUrl = new StringBuffer(imageTargetMapping.toExternalForm());
            if (!dstUrl.toString().endsWith("/")) {
                dstUrl.append("/");
            }
            boolean b = false;
            for (int i = 0; i < parts.length; ++i) {
                if ("".equals(parts[i])) continue;
                if (b) {
                    dstUrl.append("/");
                }
                dstUrl.append(parts[i]);
                b = true;
            }
            String dstUrlString = dstUrl.toString().replaceAll(" ", "%20");
            out = null;
            try {
                out = new URL(dstUrlString);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block6;
                this.log.warn("Strings in Java suck!!!", (Throwable)e);
            }
        }
        return out;
    }

    public String getValidatedConceptName(String conceptName) {
        String validatedName;
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        conceptDAO.startTransaction();
        Concept concept = conceptDAO.findByName(conceptName);
        if (concept == null) {
            this.log.warn("Unable to find '" + conceptName + "' in the knowledgebase.");
            validatedName = conceptName;
        } else {
            validatedName = concept.getPrimaryConceptName().getName();
        }
        conceptDAO.endTransaction();
        return validatedName;
    }

    public static String makeVideoArchiveName(String platform, int seqNumber, int tapeNumber, String postfix) {
        StringBuffer sb = new StringBuffer();
        sb.append(platform.charAt(0));
        sb.append(f0123.format(seqNumber));
        sb.append("-");
        sb.append(f01.format(tapeNumber));
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    public static Set<VideoFrame> toVideoFrames(Collection<Observation> observations) {
        return new HashSet<VideoFrame>(Collections2.transform(observations, (Function)new Function<Observation, VideoFrame>(){

            public VideoFrame apply(Observation from) {
                return from.getVideoFrame();
            }
        }));
    }

    public Collection<Observation> updateAndValidate(Collection<Observation> observations) {
        Vector<Observation> updatedObservations = new Vector<Observation>(observations.size());
        ObservationDAO dao = this.toolBelt.getAnnotationDAOFactory().newObservationDAO();
        AssociationDAO aDao = this.toolBelt.getAnnotationDAOFactory().newAssociationDAO(dao.getEntityManager());
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        conceptDAO.startTransaction();
        dao.startTransaction();
        for (Observation observation : observations) {
            if ((observation = dao.updateFields(observation)) == null) continue;
            updatedObservations.add(observation);
            dao.validateName((Object)observation, conceptDAO);
            for (Association association : new ArrayList(observation.getAssociations())) {
                aDao.validateName((Object)association, conceptDAO);
            }
        }
        dao.endTransaction();
        dao.close();
        conceptDAO.endTransaction();
        conceptDAO.close();
        return updatedObservations;
    }

    public Collection<CameraData> updateCameraDataUrls(VideoArchive videoArchive, File imageTarget, URL imageTargetMapping) throws MalformedURLException {
        ArrayList<CameraData> cameraDatas = new ArrayList<CameraData>();
        DAO dao = this.toolBelt.getAnnotationDAOFactory().newDAO();
        dao.startTransaction();
        videoArchive = (VideoArchive)dao.find((Object)videoArchive);
        List videoFrames = videoArchive.getVideoFrames();
        URL imageTargetUrl = imageTarget.toURI().toURL();
        String imageTargetExternalForm = imageTargetUrl.toExternalForm();
        for (VideoFrame videoFrame : videoFrames) {
            CameraData cameraData = videoFrame.getCameraData();
            String imageReference = (cameraData = (CameraData)dao.find((Object)cameraData)).getImageReference();
            if (imageReference == null || !imageReference.startsWith(imageTargetExternalForm)) continue;
            URL imageReferenceURL = new URL(imageReference);
            File imageReferenceFile = URLUtilities.toFile((URL)imageReferenceURL);
            URL newUrl = this.fileToUrl(imageReferenceFile, imageTarget, imageTargetMapping);
            cameraData.setImageReference(newUrl.toExternalForm());
            cameraDatas.add(cameraData);
        }
        dao.endTransaction();
        dao.close();
        return cameraDatas;
    }
}

