/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.jdesktop.swingx.JXTree;
import org.mbari.swing.SearchableTreePanel;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.ppanel.FrameGrabPanel;
import vars.annotation.ui.ppanel.PCameraDataPanel;
import vars.annotation.ui.ppanel.PObservationPanel;
import vars.annotation.ui.ppanel.PPhysicalDataPanel;
import vars.annotation.ui.ppanel.PVideoArchivePanel;
import vars.annotation.ui.ppanel.VideoArchiveEditorPanel;
import vars.knowledgebase.Concept;
import vars.shared.ui.UIDecorator;
import vars.shared.ui.tree.ConceptTreeCellRenderer;
import vars.shared.ui.tree.ConceptTreeModel;
import vars.shared.ui.tree.ConceptTreeNode;
import vars.shared.ui.tree.ConceptTreePanel;
import vars.shared.ui.tree.ConceptTreePopupMenu;
import vars.shared.ui.tree.JTreeDragAndDropDecorator;

public class MiscTabsPanel
extends JPanel {
    private JTabbedPane tabbedPane;
    private final ToolBelt toolbelt;
    private UIDecorator treeDecorator;
    private SearchableTreePanel treePanel;
    private EventTopicSubscriber<String> lookupConceptSubscriber;

    public MiscTabsPanel(ToolBelt toolbelt) {
        this.toolbelt = toolbelt;
        this.initComponents();
        this.initTabs();
    }

    public SearchableTreePanel getTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new ConceptTreePanel(this.toolbelt.getKnowledgebaseDAOFactory());
            ConceptTreeModel treeModel = new ConceptTreeModel(this.toolbelt.getKnowledgebaseDAOFactory());
            JXTree tree = new JXTree((TreeModel)treeModel);
            tree.setCellRenderer((TreeCellRenderer)new ConceptTreeCellRenderer());
            this.treeDecorator = new JTreeDragAndDropDecorator((JTree)tree);
            this.treePanel.setJTree((JTree)tree);
            ((ConceptTreePanel)this.treePanel).setPopupMenu((JPopupMenu)new ConceptTreePopupMenu((JTree)tree, this.toolbelt.getKnowledgebaseDAOFactory()));
            this.lookupConceptSubscriber = (topic, data) -> this.treePanel.goToMatchingNode(data, false);
            this.toolbelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener((JTree)tree){
                final /* synthetic */ JTree val$tree;
                {
                    this.val$tree = jTree;
                }

                public void afterClear(CacheClearedEvent evt) {
                    TreePath treePath = this.val$tree.getSelectionPath();
                    if (treePath != null) {
                        ConceptTreeNode node = (ConceptTreeNode)treePath.getLastPathComponent();
                        Concept concept = (Concept)node.getUserObject();
                        ((ConceptTreePanel)MiscTabsPanel.this.treePanel).refreshAndOpenNode(concept);
                    } else {
                        ((ConceptTreePanel)MiscTabsPanel.this.treePanel).refresh();
                    }
                }

                public void beforeClear(CacheClearedEvent evt) {
                }
            });
            EventBus.subscribe((String)"vars-annotation.ui.StateLookup-SelectedConcept", this.lookupConceptSubscriber);
        }
        return this.treePanel;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MiscTabsPanel.this.resizeHandler(evt);
            }
        });
        this.add((Component)this.tabbedPane, "Center");
    }

    private void initTabs() {
        this.tabbedPane.add("Frame-grab", new FrameGrabPanel(this.toolbelt));
        this.tabbedPane.add("Bulk Editor", new VideoArchiveEditorPanel(this.toolbelt));
        this.tabbedPane.add("Knowledge Base", (Component)this.getTreePanel());
        this.tabbedPane.add("Observation", new PObservationPanel(this.toolbelt));
        this.tabbedPane.add("Video Archive", new PVideoArchivePanel(this.toolbelt));
        this.tabbedPane.add("Physical Data", new PPhysicalDataPanel(this.toolbelt));
        this.tabbedPane.add("Camera Data", new PCameraDataPanel(this.toolbelt));
    }

    private void resizeHandler(ComponentEvent evt) {
        this.tabbedPane.setSize(this.getSize());
        Component[] cs = this.tabbedPane.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            cs[i].setSize(this.getSize());
        }
    }
}

