/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Optional;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.ui.swing.TimeCodeSelectionFrame;
import org.mbari.vcr4j.ui.swing.TimeSelectPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.ChangeTimeCodeAction;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;

public class ChangeTimeCodeFrame
extends TimeCodeSelectionFrame {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ToolBelt toolBelt;
    private ChangeTimeCodeAction changeTimeCodeAction;

    public ChangeTimeCodeFrame(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        AnnotationProcessor.process((Object)((Object)this));
    }

    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void updateObservationSelection(ObservationsSelectedEvent selectionEvent) {
        if (selectionEvent.getSelectionSource() != this) {
            this.update(selectionEvent.get());
        }
    }

    public ActionListener getOkActionListener() {
        if (this.okActionListener == null) {
            this.okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection<Observation> observations = StateLookup.getSelectedObservations();
                    if (observations.size() == 1) {
                        ChangeTimeCodeFrame.this.getChangeTimeCodeAction().setTimeCode(ChangeTimeCodeFrame.this.getTimePanel().getTimeAsString());
                        ChangeTimeCodeFrame.this.getChangeTimeCodeAction().doAction();
                    }
                    ChangeTimeCodeFrame.this.setVisible(false);
                }
            };
        }
        return this.okActionListener;
    }

    private ChangeTimeCodeAction getChangeTimeCodeAction() {
        if (this.changeTimeCodeAction == null) {
            this.changeTimeCodeAction = new ChangeTimeCodeAction(this.toolBelt);
        }
        return this.changeTimeCodeAction;
    }

    public void update(Object selectedObservations) {
        if (selectedObservations == null) {
            return;
        }
        Collection obs = (Collection)selectedObservations;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int frame = 0;
        if (obs.size() == 1) {
            String stc;
            VideoFrame vf = ((Observation)obs.iterator().next()).getVideoFrame();
            if (vf != null && (stc = vf.getTimecode()) != null) {
                try {
                    Optional hmsfOpt = HMSF.from((String)stc);
                    if (hmsfOpt.isPresent()) {
                        HMSF hmsf = (HMSF)hmsfOpt.get();
                        hour = hmsf.getHour();
                        minute = hmsf.getMinute();
                        second = hmsf.getSecond();
                        frame = hmsf.getFrame();
                    }
                }
                catch (Exception e) {
                    this.log.info("Failed to parse timecode of " + stc);
                }
            }
            TimeSelectPanel tp = this.getTimePanel();
            tp.getHourWidget().setTime(hour);
            tp.getMinuteWidget().setTime(minute);
            tp.getSecondWidget().setTime(second);
            tp.getFrameWidget().setTime(frame);
            tp.getHourWidget().getTextField().requestFocus();
        }
    }
}

