/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Frame;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.swing.SplashFrame;
import org.mbari.util.SystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Observation;
import vars.annotation.ui.AnnotationFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.ExitTopicSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.knowledgebase.Concept;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;
import vars.shared.ui.event.FatalExceptionSubscriber;
import vars.shared.ui.event.LoggingEventSubscriber;
import vars.shared.ui.event.NonFatalErrorSubscriber;
import vars.shared.ui.event.WarningSubscriber;
import vars.shared.util.ActiveAppBeacon;
import vars.shared.util.ActiveAppPinger;

public class App {
    private RXEventBus eventBus = new RXEventBus();
    private AnnotationFrame annotationFrame;
    private ToolBelt toolBelt;
    private static final List<EventTopicSubscriber> GC_PREVENTION = new Vector<EventTopicSubscriber>();
    private static final List<EventSubscriber> GC_PREVENTION_EVENTS = new Vector<EventSubscriber>();
    public static final Collection<Integer> BEACON_PORTS = Lists.newArrayList((Object[])new Integer[]{4002, 4121, 5097, 6238, 6609, 7407, 8169, 9069, 9669, 16569});
    public static final String BEACON_MESSAGE = "VARS Annotation";
    private static ActiveAppBeacon activeAppBeacon;

    public App() {
        ImageIcon mbariLogo = new ImageIcon(this.getClass().getResource("/annotation-splash.png"));
        SplashFrame splashFrame = new SplashFrame(mbariLogo);
        splashFrame.setVisible(true);
        splashFrame.setMessage(" Starting application beacon ...");
        activeAppBeacon = new ActiveAppBeacon(BEACON_PORTS, BEACON_MESSAGE);
        splashFrame.setMessage(" Initializing configuration ...");
        splashFrame.setVisible(true);
        Injector injector = StateLookup.GUICE_INJECTOR;
        try {
            this.toolBelt = (ToolBelt)((Object)injector.getInstance(ToolBelt.class));
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException("Initialization failed. Perhaps VARS can't connect to the database", e);
            new FatalExceptionSubscriber(null).onEvent("vars.shared.ui.GlobalLookup-TopicFatalError", (Exception)ex);
        }
        if (this.toolBelt == null) {
            System.exit(-1);
        }
        splashFrame.setMessage(" Loading authentication policies ...");
        try {
            this.toolBelt.getMiscDAOFactory().newUserAccountDAO().findAll();
        }
        catch (Exception e) {
            new FatalExceptionSubscriber(null).onEvent("vars.shared.ui.GlobalLookup-TopicFatalError", e);
        }
        StateLookup.setApp(this);
        splashFrame.setMessage(" Pre-loading knowledgebase ... be patient");
        Worker.post((Job)new Job(){

            public Object run() {
                AnnotationPersistenceService service = App.this.toolBelt.getAnnotationPersistenceService();
                Concept root = service.findRootConcept();
                service.findDescendantNamesFor(root);
                return null;
            }
        });
        splashFrame.setMessage("Assembling the user interface ...");
        StateLookup.setSelectedObservations(new Vector<Observation>());
        FatalExceptionSubscriber fatalErrorSubscriber = new FatalExceptionSubscriber((Frame)this.getAnnotationFrame());
        NonFatalErrorSubscriber nonFatalErrorSubscriber = new NonFatalErrorSubscriber((Frame)this.getAnnotationFrame());
        WarningSubscriber warningSubscriber = new WarningSubscriber((Frame)this.getAnnotationFrame());
        ExitTopicSubscriber exitSubscriber = new ExitTopicSubscriber();
        LoggingEventSubscriber loggingSubscriber = new LoggingEventSubscriber();
        GC_PREVENTION.add((EventTopicSubscriber)fatalErrorSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)nonFatalErrorSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)warningSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)exitSubscriber);
        GC_PREVENTION_EVENTS.add((EventSubscriber)loggingSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (EventTopicSubscriber)fatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (EventTopicSubscriber)nonFatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicWarning", (EventTopicSubscriber)warningSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-Exit", (EventTopicSubscriber)exitSubscriber);
        EventBus.subscribe(VideoArchiveChangedEvent.class, (EventSubscriber)loggingSubscriber);
        AnnotationFrame frame = this.getAnnotationFrame();
        frame.setDefaultCloseOperation(3);
        StateLookup.setAnnotationFrame(frame);
        frame.pack();
        splashFrame.dispose();
        frame.setVisible(true);
    }

    public AnnotationFrame getAnnotationFrame() {
        if (this.annotationFrame == null) {
            this.annotationFrame = new AnnotationFrame(this.toolBelt, this.eventBus);
        }
        return this.annotationFrame;
    }

    public static void main(String[] args) {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (SystemUtilities.isMacOS()) {
            SystemUtilities.configureMacOSApplication((String)BEACON_MESSAGE);
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                Logger log = LoggerFactory.getLogger(thread.getClass());
                log.error("Exception in thread [" + thread.getName() + "]", e);
            }
        });
        GlobalStateLookup.getSettingsDirectory();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(App.class).warn("Failed to set system look and feel", (Throwable)e);
        }
        if (ActiveAppPinger.pingAll(BEACON_PORTS, (String)BEACON_MESSAGE)) {
            JOptionPane.showMessageDialog(null, "An instance of the VARS Annotation application is already running. Exiting ...");
        } else {
            try {
                SwingUtilities.invokeLater(() -> new App());
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(App.class).warn("An error occurred on startup", e);
            }
        }
    }
}

