/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.inject.Injector;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.mbari.swing.WaitIndicator;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.UserAccount;
import vars.VARSException;
import vars.VarsUserPreferencesFactory;
import vars.annotation.AnnotationObject;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.AnnotationFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.ClearCommandQueueEvent;
import vars.annotation.ui.commandqueue.CommandQueue;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.UIEventSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.avplayer.VideoController;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.preferences.PreferenceUpdater;
import vars.shared.preferences.PreferencesService;
import vars.shared.rx.RXEventBus;

public class AnnotationFrameController
implements PreferenceUpdater,
UIEventSubscriber {
    private final String PREF_WIDTH = "width";
    private final String PREF_HEIGHT = "height";
    private final String PREF_OUTER_DIVIDER_LOCATION = "outerSplitPaneDividerLocation";
    private final String PREF_INNER_DIVIDER_LOCATION = "innerSplitPaneDividerLocation";
    private final String PREF_ALLCONTROLS_DIVIDER_LOCATION = "allControlsSplitPaneDividerLocation";
    private final String PREF_CONTROLS_DIVIDER_LOCATION = "controlsSplitPaneDividerLocation";
    private final String PREF_TABLE_WIDTH = "tableScrollPaneWidth";
    private final String PREF_TABLE_HEIGHT = "tableScrollPaneHeight";
    private final AnnotationFrame annotationFrame;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ToolBelt toolBelt;
    private final RXEventBus eventBus;
    private final CommandQueue commandQueue;

    public AnnotationFrameController(AnnotationFrame annotationFrame, ToolBelt toolBelt, RXEventBus eventBus) {
        this.annotationFrame = annotationFrame;
        this.toolBelt = toolBelt;
        this.eventBus = eventBus;
        this.commandQueue = new CommandQueue(toolBelt);
        this.initialize();
        AnnotationProcessor.process((Object)this);
    }

    private void initialize() {
        Thread cleanupThread = new Thread(() -> {
            this.log.info("Persisting preferences");
            this.persistPreferences();
            this.log.info("Saving last Observations to persistent storage during JVM shutdown");
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            this.toolBelt.getPersistenceController().updateAndValidate(new ArrayList<Observation>(observations));
            VideoArchive videoArchive = StateLookup.getVideoArchive();
            if (videoArchive != null) {
                this.updateCameraData(videoArchive);
            }
            this.log.info("Shutdown thread is finished. Bye Bye");
        }, "VARS-cleanupBeforeShutdownThread");
        Runtime.getRuntime().addShutdownHook(cleanupThread);
        this.toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){
            private WaitIndicator waitIndicator;

            public void afterClear(CacheClearedEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitIndicator.dispose();
                        waitIndicator = null;
                    }
                });
            }

            public void beforeClear(CacheClearedEvent evt) {
                this.waitIndicator = new LabeledSpinningDialWaitIndicator((JFrame)AnnotationFrameController.this.annotationFrame, "Refreshing");
            }
        });
        StateLookup.preferencesProperty().addListener((obs, oldVal, newVal) -> {
            this.persistPreferences((Preferences)oldVal);
            this.loadPreferences((Preferences)newVal);
        });
        StateLookup.videoArchiveProperty().addListener((obs, oldVal, videoArchive) -> {
            Runnable runnable = () -> {
                if (videoArchive != null) {
                    this.updateCameraData((VideoArchive)videoArchive);
                    this.toolBelt.getPersistenceCache().evict((AnnotationObject)videoArchive);
                }
            };
            new Thread(runnable, "UpdateCameraDataThread-" + System.currentTimeMillis()).start();
        });
        this.eventBus.toObserverable().ofType(SetVideoArchiveMsg.class).subscribe(msg -> EventBus.publish((Object)new VideoArchiveChangedEvent((Object)null, msg.getVideoArchive())));
        this.eventBus.toObserverable().ofType(SetVideoControllerMsg.class).subscribe(msg -> StateLookup.setVideoController((VideoController<? extends VideoState, ? extends VideoError>)msg.getVideoController()));
    }

    public void persistPreferences() {
        Preferences userPreferences = StateLookup.getPreferences();
        this.persistPreferences(userPreferences);
    }

    private void persistPreferences(Preferences userPreferences) {
        if (userPreferences != null) {
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                throw new VARSException("Unable to get hostname", (Throwable)ex);
            }
            String className = this.getClass().getCanonicalName();
            Preferences preferences = userPreferences.node(hostName).node(className);
            Dimension size = this.annotationFrame.getSize();
            preferences.putInt("width", size.width);
            preferences.putInt("height", size.height);
            Dimension tablePaneSize = this.annotationFrame.getTableScrollPane().getSize();
            preferences.putInt("tableScrollPaneWidth", tablePaneSize.width);
            preferences.putInt("tableScrollPaneHeight", tablePaneSize.height);
            int outerDividerLocation = this.annotationFrame.getOuterSplitPane().getDividerLocation();
            preferences.putInt("outerSplitPaneDividerLocation", outerDividerLocation);
            int innerDividerLocation = this.annotationFrame.getInnerSplitPane().getDividerLocation();
            preferences.putInt("innerSplitPaneDividerLocation", innerDividerLocation);
            int allControlsDividerLocation = this.annotationFrame.getAllControlsSplitPane().getDividerLocation();
            preferences.putInt("allControlsSplitPaneDividerLocation", allControlsDividerLocation);
            int controlsDividerLocation = this.annotationFrame.getControlsPanelSplitPane().getDividerLocation();
            preferences.putInt("controlsSplitPaneDividerLocation", controlsDividerLocation);
            Injector injector = StateLookup.GUICE_INJECTOR;
            PreferencesFactory preferencesFactory = (PreferencesFactory)injector.getInstance(PreferencesFactory.class);
            PreferencesService preferencesService = new PreferencesService(preferencesFactory);
            VideoController videoController = StateLookup.getVideoController();
            try {
                preferencesService.persistLastVideoConnectionId(preferencesService.getHostname(), videoController.getConnectionID());
            }
            catch (NullPointerException e) {
                this.log.info("Did not save Last VideoController ID preference. Most likely this was attempted after the video connection was closed");
            }
        }
    }

    private void loadPreferences(Preferences userPreferences) {
        if (userPreferences != null) {
            int controlsDividerLocation;
            int allControlsDividerLocation;
            int innerDividerLocation;
            int outerDividerLocation;
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                this.log.warn("Unable to get hostname, defaulting to 'localhost'.", (Throwable)ex);
                hostName = "localhost";
            }
            String className = this.getClass().getCanonicalName();
            Preferences hostPreferences = userPreferences.node(hostName);
            Preferences preferences = hostPreferences.node(className);
            Dimension currentSize = this.annotationFrame.getSize();
            int width = preferences.getInt("width", currentSize.width);
            int height = preferences.getInt("height", currentSize.height);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            width = width <= screenSize.width ? width : screenSize.width;
            height = height <= screenSize.height ? height : screenSize.height;
            this.annotationFrame.setSize(width, height);
            this.annotationFrame.validate();
            int tablePaneWidth = preferences.getInt("tableScrollPaneWidth", -1);
            int tablePaneHeight = preferences.getInt("tableScrollPaneHeight", -1);
            if (tablePaneWidth > 0 && tablePaneHeight > 0) {
                this.annotationFrame.getTableScrollPane().setPreferredSize(new Dimension(tablePaneWidth, tablePaneHeight));
            }
            if ((outerDividerLocation = preferences.getInt("outerSplitPaneDividerLocation", -1)) > 0) {
                this.annotationFrame.getOuterSplitPane().setDividerLocation(outerDividerLocation);
            }
            if ((innerDividerLocation = preferences.getInt("innerSplitPaneDividerLocation", -1)) > 0) {
                this.annotationFrame.getInnerSplitPane().setDividerLocation(innerDividerLocation);
            }
            if ((allControlsDividerLocation = preferences.getInt("allControlsSplitPaneDividerLocation", -1)) > 0) {
                this.annotationFrame.getAllControlsSplitPane().setDividerLocation(allControlsDividerLocation);
            }
            if ((controlsDividerLocation = preferences.getInt("controlsSplitPaneDividerLocation", -1)) > 0) {
                this.annotationFrame.getControlsPanelSplitPane().setDividerLocation(controlsDividerLocation);
            }
            Injector injector = StateLookup.GUICE_INJECTOR;
            PreferencesFactory preferencesFactory = (PreferencesFactory)injector.getInstance(PreferencesFactory.class);
            PreferencesService preferencesService = new PreferencesService(preferencesFactory);
        }
    }

    public void updateCameraData(VideoArchive videoArchive) {
        PreferencesFactory preferencesFactory = StateLookup.PREFERENCES_FACTORY;
        UserAccount userAccount = StateLookup.getUserAccount();
        if (videoArchive != null && preferencesFactory instanceof VarsUserPreferencesFactory && userAccount != null) {
            VarsUserPreferencesFactory vpf = (VarsUserPreferencesFactory)preferencesFactory;
            PreferencesService preferencesService = new PreferencesService((PreferencesFactory)vpf);
            File imageTarget = preferencesService.findImageTarget(userAccount.getUserName(), preferencesService.getHostname());
            URL imageTargetMapping = preferencesService.findImageTargetMapping(userAccount.getUserName(), preferencesService.getHostname());
            try {
                this.toolBelt.getPersistenceController().updateCameraDataUrls(videoArchive, imageTarget, imageTargetMapping);
            }
            catch (MalformedURLException ex) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)ex);
            }
        }
    }

    @Override
    public void respondTo(ObservationsAddedEvent event) {
    }

    @Override
    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void respondTo(ObservationsChangedEvent event) {
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        ArrayList<Observation> selectedObservations = new ArrayList<Observation>(observations);
        ArrayList changedObservations = new ArrayList((Collection)event.get());
        ArrayList<Observation> updatedObservations = new ArrayList<Observation>(selectedObservations.size());
        for (Observation observation : selectedObservations) {
            int idx = changedObservations.indexOf(observation);
            if (idx >= 0) {
                updatedObservations.add((Observation)changedObservations.get(idx));
                continue;
            }
            updatedObservations.add(observation);
        }
        StateLookup.setSelectedObservations(updatedObservations);
    }

    @Override
    @EventSubscriber(eventClass=ObservationsRemovedEvent.class)
    public void respondTo(ObservationsRemovedEvent event) {
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        ArrayList<Observation> selectedObservations = new ArrayList<Observation>(observations);
        ArrayList removedObservations = new ArrayList((Collection)event.get());
        ArrayList<Observation> updatedObservations = new ArrayList<Observation>(selectedObservations.size());
        for (Observation observation : selectedObservations) {
            int idx = removedObservations.indexOf(observation);
            if (idx >= 0) continue;
            updatedObservations.add(observation);
        }
        StateLookup.setSelectedObservations(updatedObservations);
    }

    @Override
    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent event) {
        ArrayList<Observation> observations = event.get() == null ? new ArrayList() : (Collection)event.get();
        StateLookup.setSelectedObservations(observations);
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        StateLookup.setVideoArchive((VideoArchive)event.get());
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        StateLookup.setVideoArchive((VideoArchive)event.get());
        EventBus.publish((Object)new ClearCommandQueueEvent());
    }

    @Override
    public void respondTo(VideoFramesChangedEvent event) {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            Collection videoFrames = (Collection)event.get();
            for (VideoFrame videoFrame : videoFrames) {
                if (!videoFrame.getVideoArchive().equals(videoArchive)) continue;
                StateLookup.setVideoArchive(null);
                StateLookup.setVideoArchive(videoArchive);
                break;
            }
        }
    }
}

