/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.vcr4j.time.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ActionPanel;
import vars.annotation.ui.AnnotationFrameController;
import vars.annotation.ui.MiscTabsPanel;
import vars.annotation.ui.QuickControlsPanel;
import vars.annotation.ui.RefreshButton;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.StatusLabelForPerson;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.VARSProperties;
import vars.annotation.ui.VideoPlayersPanel;
import vars.annotation.ui.buttons.RedoButton;
import vars.annotation.ui.buttons.UndoButton;
import vars.annotation.ui.cbpanel.ConceptButtonPanel;
import vars.annotation.ui.commandqueue.RedoEvent;
import vars.annotation.ui.commandqueue.UndoEvent;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.UIEventSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.preferences.PreferenceFrameButton;
import vars.annotation.ui.roweditor.RowEditorPanel;
import vars.annotation.ui.table.JXObservationTable;
import vars.annotation.ui.table.JXObservationTableColumnModel;
import vars.annotation.ui.table.ObservationTableModel;
import vars.annotation.ui.video.VideoControlPanel;
import vars.annotation.ui.videoset.VideoArchiveSetEditorButton;
import vars.avplayer.VideoController;
import vars.shared.rx.RXEventBus;

public class AnnotationFrame
extends JFrame
implements UIEventSubscriber {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JPanel actionPanel;
    private JSplitPane allControlsSplitPane;
    private JPanel conceptButtonPanel;
    private final AnnotationFrameController controller;
    private JPanel controlsPanel;
    private JSplitPane controlsPanelSplitPane;
    private JSplitPane innerSplitPane;
    private JPanel miscTabsPanel;
    private JSplitPane outerSplitPane;
    private QuickControlsPanel quickControlsPanel;
    private RowEditorPanel rowEditorPanel;
    private JXObservationTable table;
    private JPopupMenu tablePopupMenu;
    private JScrollPane tableScrollPane;
    private JToolBar toolBar;
    private final ToolBelt toolBelt;
    private final RXEventBus eventBus;
    private VideoControlPanel videoControlPanel;
    private VideoArchive videoArchive;

    public AnnotationFrame(ToolBelt toolBelt, RXEventBus eventBus) throws HeadlessException {
        this.toolBelt = toolBelt;
        this.eventBus = eventBus;
        this.controller = new AnnotationFrameController(this, toolBelt, eventBus);
        AnnotationProcessor.process((Object)this);
        this.initialize();
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new ActionPanel(this.toolBelt);
            this.actionPanel.setMinimumSize(new Dimension(350, 100));
        }
        return this.actionPanel;
    }

    protected JSplitPane getAllControlsSplitPane() {
        if (this.allControlsSplitPane == null) {
            this.allControlsSplitPane = new JSplitPane(0);
            this.allControlsSplitPane.setLeftComponent(this.getControlsPanelSplitPane());
            this.allControlsSplitPane.setRightComponent(this.getConceptButtonPanel());
        }
        return this.allControlsSplitPane;
    }

    private JPanel getConceptButtonPanel() {
        if (this.conceptButtonPanel == null) {
            this.conceptButtonPanel = new ConceptButtonPanel(this.toolBelt);
        }
        return this.conceptButtonPanel;
    }

    private JPanel getControlsPanel() {
        if (this.controlsPanel == null) {
            this.controlsPanel = new JPanel();
            this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 0));
            this.controlsPanel.add(this.getActionPanel());
            this.controlsPanel.add((Component)((Object)this.getVideoControlPanel()));
        }
        return this.controlsPanel;
    }

    protected JSplitPane getControlsPanelSplitPane() {
        if (this.controlsPanelSplitPane == null) {
            this.controlsPanelSplitPane = new JSplitPane();
            this.controlsPanelSplitPane.setOrientation(1);
            this.controlsPanelSplitPane.setLeftComponent(this.getRowEditorPanel());
            this.controlsPanelSplitPane.setRightComponent(this.getControlsPanel());
            Dimension size = this.controlsPanelSplitPane.getPreferredSize();
            this.controlsPanelSplitPane.setPreferredSize(new Dimension(size.width, 200));
        }
        return this.controlsPanelSplitPane;
    }

    protected JSplitPane getInnerSplitPane() {
        if (this.innerSplitPane == null) {
            this.innerSplitPane = new JSplitPane();
            this.innerSplitPane.setLeftComponent(this.getTableScrollPane());
            this.innerSplitPane.setRightComponent(this.getMiscTabsPanel());
            this.innerSplitPane.setOneTouchExpandable(true);
        }
        return this.innerSplitPane;
    }

    private JPanel getMiscTabsPanel() {
        if (this.miscTabsPanel == null) {
            this.miscTabsPanel = new MiscTabsPanel(this.toolBelt);
        }
        return this.miscTabsPanel;
    }

    protected JSplitPane getOuterSplitPane() {
        if (this.outerSplitPane == null) {
            this.outerSplitPane = new JSplitPane();
            this.outerSplitPane.setOrientation(0);
            this.outerSplitPane.setLeftComponent(this.getInnerSplitPane());
            this.outerSplitPane.setRightComponent(this.getAllControlsSplitPane());
        }
        return this.outerSplitPane;
    }

    private QuickControlsPanel getQuickControlPanel() {
        if (this.quickControlsPanel == null) {
            this.quickControlsPanel = new QuickControlsPanel(this.toolBelt);
        }
        return this.quickControlsPanel;
    }

    public RowEditorPanel getRowEditorPanel() {
        if (this.rowEditorPanel == null) {
            this.rowEditorPanel = new RowEditorPanel(this.toolBelt);
            this.rowEditorPanel.setPreferredSize(new Dimension(600, 250));
        }
        return this.rowEditorPanel;
    }

    protected JXObservationTable getTable() {
        if (this.table == null) {
            this.table = new JXObservationTable();
            this.table.setFocusable(false);
            ((JXObservationTableColumnModel)((Object)this.table.getColumnModel())).setImageView(VARSProperties.getShowRecordedDateInTable());
            String upTable = "up-table";
            AbstractAction upAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int numRows = AnnotationFrame.this.table.getRowCount();
                    int currentRow = AnnotationFrame.this.table.getSelectionModel().getLeadSelectionIndex();
                    int nextRow = currentRow - 1 < 0 ? numRows - 1 : currentRow - 1;
                    AnnotationFrame.this.table.getSelectionModel().setSelectionInterval(nextRow, nextRow);
                    AnnotationFrame.this.table.scrollToVisible(nextRow, 0);
                }
            };
            this.table.getInputMap(2).put(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), upTable);
            this.table.getInputMap(2).put(KeyStroke.getKeyStroke(33, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), upTable);
            this.table.getActionMap().put(upTable, upAction);
            String downTable = "down-table";
            AbstractAction downAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int numRows = AnnotationFrame.this.table.getRowCount();
                    int currentRow = AnnotationFrame.this.table.getSelectionModel().getLeadSelectionIndex();
                    int nextRow = currentRow + 1 >= numRows ? 0 : currentRow + 1;
                    AnnotationFrame.this.table.getSelectionModel().setSelectionInterval(nextRow, nextRow);
                    AnnotationFrame.this.table.scrollToVisible(nextRow, 0);
                }
            };
            this.table.getInputMap(2).put(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), downTable);
            this.table.getInputMap(2).put(KeyStroke.getKeyStroke(34, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), downTable);
            this.table.getActionMap().put(downTable, downAction);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int[] rows = AnnotationFrame.this.table.getSelectedRows();
                        Vector<Observation> selectedObservations = new Vector<Observation>(rows.length);
                        for (int i = 0; i < rows.length; ++i) {
                            selectedObservations.add(AnnotationFrame.this.table.getObservationAt(rows[i]));
                        }
                        Collection<Observation> oldObservations = StateLookup.getSelectedObservations();
                        HashSet<Observation> oldSelectedObservations = new HashSet<Observation>(oldObservations);
                        if (!Sets.symmetricDifference(new HashSet(selectedObservations), oldSelectedObservations).isEmpty()) {
                            EventBus.publish((Object)new ObservationsSelectedEvent((Object)AnnotationFrame.this.table, (Collection<Observation>)selectedObservations));
                        }
                    }
                }
            });
            this.table.setComponentPopupMenu(this.getTablePopupMenu());
            StateLookup.setObservationTable(this.table);
        }
        return this.table;
    }

    protected JPopupMenu getTablePopupMenu() {
        if (this.tablePopupMenu == null) {
            this.tablePopupMenu = new JPopupMenu();
            JMenuItem seekItem = new JMenuItem("Seek to this timecode");
            this.tablePopupMenu.add(seekItem);
            StateLookup.selectedObservationsProperty().addListener((obs, oldVal, observations) -> seekItem.setEnabled(observations.size() == 1));
            seekItem.addActionListener(e -> {
                Collection<Observation> observations;
                VideoController controller = StateLookup.getVideoController();
                if (controller != null && (observations = StateLookup.getSelectedObservations()).size() == 1) {
                    Observation obs = observations.iterator().next();
                    Timecode timecode = new Timecode(obs.getVideoFrame().getTimecode());
                    controller.seek(timecode);
                }
            });
        }
        return this.tablePopupMenu;
    }

    protected JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane(22, 30);
            this.tableScrollPane.setViewportView((Component)((Object)this.getTable()));
        }
        return this.tableScrollPane;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add((Component)((Object)new UndoButton()));
            this.toolBar.add((Component)((Object)new RedoButton()));
            this.toolBar.add((Component)((Object)new RefreshButton(this.toolBelt)));
            this.toolBar.add(new VideoArchiveSetEditorButton(this.toolBelt));
            this.toolBar.add((Component)((Object)new PreferenceFrameButton()));
            this.toolBar.add(new StatusLabelForPerson(this.toolBelt));
            this.toolBar.add(new VideoPlayersPanel(this.toolBelt, this.eventBus));
            InputMap inputMap = this.toolBar.getInputMap(2);
            KeyStroke undoStroke = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            inputMap.put(undoStroke, "undo");
            KeyStroke redoStroke = KeyStroke.getKeyStroke(90, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            inputMap.put(redoStroke, "redo");
            ActionMap actionMap = this.toolBar.getActionMap();
            actionMap.put("undo", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventBus.publish((Object)new UndoEvent());
                }
            });
            actionMap.put("redo", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventBus.publish((Object)new RedoEvent());
                }
            });
        }
        return this.toolBar;
    }

    private VideoControlPanel getVideoControlPanel() {
        if (this.videoControlPanel == null) {
            this.videoControlPanel = new VideoControlPanel();
        }
        return this.videoControlPanel;
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getOuterSplitPane(), "Center");
        this.getContentPane().add((Component)this.getQuickControlPanel(), "South");
        this.getContentPane().add((Component)this.getToolBar(), "North");
    }

    public AnnotationFrameController getController() {
        return this.controller;
    }

    @Override
    @EventSubscriber(eventClass=ObservationsAddedEvent.class)
    public void respondTo(ObservationsAddedEvent event) {
        this.respondTo(new ObservationsChangedEvent((Object)this, (Collection)event.get()));
    }

    @Override
    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void respondTo(ObservationsChangedEvent event) {
        JXObservationTable observationTable = this.getTable();
        if (event.getEventSource() != observationTable) {
            JTable table = observationTable.getJTable();
            ObservationTableModel model = (ObservationTableModel)((Object)table.getModel());
            for (Observation observation : (Collection)event.get()) {
                Rectangle visibleRect;
                Rectangle cellRect;
                int row = model.getObservationRow(observation);
                if (row > -1 && row < model.getRowCount()) {
                    observationTable.updateObservation(observation);
                    continue;
                }
                observationTable.addObservation(observation);
                row = model.getObservationRow(observation);
                if (row <= -1 || row >= model.getRowCount() || !(cellRect = table.getCellRect(row, 0, true)).intersects(visibleRect = table.getVisibleRect())) continue;
                table.scrollRectToVisible(cellRect);
            }
        }
    }

    @Override
    @EventSubscriber(eventClass=ObservationsRemovedEvent.class)
    public void respondTo(ObservationsRemovedEvent event) {
        JXObservationTable observationTable = this.getTable();
        if (event.getEventSource() != observationTable) {
            JTable table = observationTable.getJTable();
            ObservationTableModel model = (ObservationTableModel)((Object)table.getModel());
            for (Observation observation : (Collection)event.get()) {
                observationTable.removeObservation(observation);
            }
        }
    }

    @Override
    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent event) {
        JXObservationTable observationTable = this.getTable();
        if (event.getSelectionSource() != observationTable) {
            observationTable.setSelectedObservations((Collection)event.get());
        }
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        VideoArchive newVideoArchive;
        VideoArchive oldVideoArchive = this.videoArchive;
        this.videoArchive = newVideoArchive = (VideoArchive)event.get();
        JXObservationTable observationTable = this.getTable();
        final JTable table = observationTable.getJTable();
        table.getSelectionModel().clearSelection();
        ((ObservationTableModel)((Object)table.getModel())).clear();
        if (newVideoArchive != null) {
            ArrayList<Observation> observations = new ArrayList<Observation>();
            DAO dao = this.toolBelt.getAnnotationDAOFactory().newDAO();
            dao.startTransaction();
            VideoArchive videoArchive = (VideoArchive)dao.find(event.get());
            List videoFrames = videoArchive.getVideoFrames();
            for (VideoFrame videoFrame : videoFrames) {
                observations.addAll(videoFrame.getObservations());
            }
            dao.endTransaction();
            dao.close();
            final Rectangle rect = table.getVisibleRect();
            this.respondTo(new ObservationsChangedEvent((Object)null, (Collection<Observation>)observations));
            if (newVideoArchive.equals(oldVideoArchive)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        table.scrollRectToVisible(rect);
                    }
                });
            }
        }
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.respondTo(new VideoArchiveChangedEvent((Object)null, (VideoArchive)event.get()));
    }

    @Override
    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
        HashSet<Observation> observations = new HashSet<Observation>();
        Collection videoFrames = (Collection)event.get();
        for (VideoFrame videoFrame : videoFrames) {
            observations.addAll(videoFrame.getObservations());
        }
        this.respondTo(new ObservationsChangedEvent((Object)null, (Collection<Observation>)observations));
    }
}

