/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.mbari.awt.layout.WrappingFlowLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.buttons.DeepCopyObservationsButton;
import vars.annotation.ui.buttons.DeleteImageReferenceButton;
import vars.annotation.ui.buttons.DeleteSelectedObservationsButton;
import vars.annotation.ui.buttons.DuplicateObservationButton;
import vars.annotation.ui.buttons.FrameCaptureButton;
import vars.annotation.ui.buttons.NewObservationButton;
import vars.annotation.ui.buttons.PropButton;

public class ActionPanel
extends JPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    FlowLayout flowLayout = new WrappingFlowLayout();
    JButton btnDeepCopy;
    JButton btnDelete;
    JButton btnFramegrab;
    JButton btnRemoveFramegrab;
    JButton btnNew;
    JButton btnShallowCopy;
    private final ToolBelt toolBelt;

    public ActionPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        PropButton.setToolBelt(toolBelt);
        this.btnDeepCopy = new DeepCopyObservationsButton(toolBelt);
        this.btnDelete = new DeleteSelectedObservationsButton(toolBelt);
        this.btnNew = new NewObservationButton(toolBelt);
        this.btnShallowCopy = new DuplicateObservationButton(toolBelt);
        this.btnFramegrab = new FrameCaptureButton(toolBelt);
        this.btnRemoveFramegrab = new DeleteImageReferenceButton(toolBelt);
        this.initialize();
        this.registerHotKeys();
    }

    void initialize() {
        this.setLayout(this.flowLayout);
        this.flowLayout.setAlignment(0);
        this.add((Component)this.btnNew, null);
        this.add((Component)this.btnShallowCopy, null);
        this.add((Component)this.btnDeepCopy, null);
        this.add((Component)this.btnFramegrab, null);
        this.add((Component)this.btnRemoveFramegrab, null);
        ResourceBundle bundle = ResourceBundle.getBundle("annotation-app", Locale.US);
        Enumeration<String> enumeration = bundle.getKeys();
        TreeMap<String, JButton> map = new TreeMap<String, JButton>();
        Injector injector = StateLookup.GUICE_INJECTOR;
        while (enumeration.hasMoreElements()) {
            String element = enumeration.nextElement();
            if (!element.startsWith("actionpanel.button")) continue;
            try {
                Class<?> clazz = Class.forName(bundle.getString(element));
                JButton button = (JButton)injector.getInstance(clazz);
                map.put(element, button);
            }
            catch (Exception ex) {
                this.log.warn("Unable to add button class specified by '" + element + "' in vars-annotation.properties", (Throwable)ex);
            }
        }
        for (String key : map.keySet()) {
            this.add((Component)map.get(key));
        }
        this.add((Component)this.btnDelete, null);
    }

    public void registerHotKeys() {
        Action[] as = new Action[]{this.btnFramegrab.getAction(), this.btnDelete.getAction(), this.btnNew.getAction(), this.btnDeepCopy.getAction(), this.btnShallowCopy.getAction()};
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        for (Action a : as) {
            actionMap.put(a.getValue("ActionCommandKey"), a);
            inputMap.put((KeyStroke)a.getValue("AcceleratorKey"), a.getValue("ActionCommandKey"));
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(127, 0);
        Action a = this.btnDelete.getAction();
        inputMap.put(stroke, a.getValue("ActionCommandKey"));
        stroke = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(stroke, a.getValue("ActionCommandKey"));
    }
}

