/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import java.util.Timer;
import java.util.TimerTask;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;
import rx.Subscriber;

public class VideoSyncDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    private Timer timer = new Timer(this.getClass().getSimpleName() + "-" + System.currentTimeMillis(), true);
    Subscriber<VideoCommand> subscriber = new Subscriber<VideoCommand>(){

        public void onCompleted() {
            VideoSyncDecorator.this.timer.cancel();
        }

        public void onError(Throwable throwable) {
            this.unsubscribe();
        }

        public void onNext(VideoCommand videoCommand) {
        }
    };

    public VideoSyncDecorator(final VideoIO<S, E> io) {
        io.getCommandSubject().subscribe(this.subscriber);
        TimerTask statusTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_STATUS);
            }
        };
        this.timer.schedule(statusTask, 0L, 1000L);
        TimerTask timecodeTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_INDEX);
            }
        };
        this.timer.schedule(timecodeTask, 0L, 333L);
    }

    protected Timer getTimer() {
        return this.timer;
    }

    @Override
    public void unsubscribe() {
        this.timer.cancel();
        this.subscriber.unsubscribe();
    }
}

