/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.decorators.VideoCommandAsString;
import org.mbari.vcr4j.decorators.VideoErrorAsString;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.decorators.VideoStateAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;

public class LoggingDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Subscriber<E> errorSubscriber = new Subscriber<E>(){

        public void onCompleted() {
            LoggingDecorator.this.log.debug("Error observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the error observable", throwable);
        }

        public void onNext(E error) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoErrorAsString((VideoError)error).toString());
            }
        }
    };
    protected final Subscriber<VideoIndex> indexSubscriber = new Subscriber<VideoIndex>(){

        public void onCompleted() {
            LoggingDecorator.this.log.debug("Index observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the index observable", throwable);
        }

        public void onNext(VideoIndex index) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoIndexAsString(index).toString());
            }
        }
    };
    protected final Subscriber<S> stateSubscriber = new Subscriber<S>(){

        public void onCompleted() {
            LoggingDecorator.this.log.debug("State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the state observable", throwable);
        }

        public void onNext(S state) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoStateAsString((VideoState)state).toString());
            }
        }
    };
    protected final Subscriber<VideoCommand> commandSubscriber = new Subscriber<VideoCommand>(){

        public void onCompleted() {
            LoggingDecorator.this.log.debug("State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the state observable", throwable);
        }

        public void onNext(VideoCommand command) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Sending: " + new VideoCommandAsString(command).toString());
            }
        }
    };

    public LoggingDecorator(VideoIO<S, E> io) {
        io.getCommandSubject().subscribe(this.commandSubscriber);
        io.getErrorObservable().subscribe(this.errorSubscriber);
        io.getStateObservable().subscribe(this.stateSubscriber);
        io.getIndexObservable().subscribe(this.indexSubscriber);
    }

    @Override
    public void unsubscribe() {
        this.errorSubscriber.unsubscribe();
        this.stateSubscriber.unsubscribe();
        this.indexSubscriber.unsubscribe();
        this.commandSubscriber.unsubscribe();
    }
}

