/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.mbari.vcr4j.time.Timecode;
import org.mbari.vcr4j.util.Preconditions;

public class VideoIndex {
    private final Optional<Instant> timestamp;
    private final Optional<Duration> elapsedTime;
    private final Optional<Timecode> timecode;

    public VideoIndex(Optional<Instant> timestamp, Optional<Duration> elapsedTime, Optional<Timecode> timecode) {
        Preconditions.checkArgument(timestamp != null && elapsedTime != null && timecode != null, "VideoIndex does not except null arguments");
        this.timestamp = timestamp;
        this.elapsedTime = elapsedTime;
        this.timecode = timecode;
    }

    public VideoIndex(Instant timestamp) {
        this(Optional.ofNullable(timestamp), Optional.empty(), Optional.empty());
    }

    public VideoIndex(Duration elapsedTime) {
        this(Optional.empty(), Optional.ofNullable(elapsedTime), Optional.empty());
    }

    public VideoIndex(Timecode timecode) {
        this(Optional.empty(), Optional.empty(), Optional.ofNullable(timecode));
    }

    public Optional<Instant> getTimestamp() {
        return this.timestamp;
    }

    public Optional<Duration> getElapsedTime() {
        return this.elapsedTime;
    }

    public Optional<Timecode> getTimecode() {
        return this.timecode;
    }

    public boolean equals(Object o) {
        Duration ecThat;
        String tcThat;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoIndex that = (VideoIndex)o;
        String tcThis = this.timecode.map(Timecode::toString).orElse("--:--:--:--");
        if (!tcThis.equals(tcThat = that.getTimecode().map(Timecode::toString).orElse("--:--:--:--"))) {
            return false;
        }
        Duration ecThis = this.elapsedTime.orElse(Duration.ZERO);
        if (!ecThis.equals(ecThat = that.getElapsedTime().orElse(Duration.ZERO))) {
            return false;
        }
        Instant tsThis = this.timestamp.orElse(Instant.MIN);
        Instant tsThat = that.getTimestamp().orElse(Instant.MIN);
        return tsThis.equals(tsThat);
    }

    public int hashCode() {
        String tcThis = this.timecode.map(Timecode::toString).orElse("--:--:--:--");
        Duration ecThis = this.elapsedTime.orElse(Duration.ZERO);
        Instant tsThis = this.timestamp.orElse(Instant.MIN);
        return tcThis.hashCode() * 31 + ecThis.hashCode() * 31 + tsThis.hashCode();
    }
}

