/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mbari.swing.JFancyButton;
import org.mbari.vcr4j.IVCR;
import org.mbari.vcr4j.IVCRState;

public class VCRShuttleSpeedPanel
extends JPanel {
    private Hashtable sliderLabels = new Hashtable();
    JSlider slider = new JSlider();
    JLabel label = new JLabel();
    private Integer currentLabelKey = 100;
    private JLabel currentLabel = new JLabel();
    private Dimension buttonSize = new Dimension(20, 20);
    JButton btnIncrease = new JFancyButton();
    JButton btnDecrease = new JFancyButton();
    private IVCR vcr;

    public VCRShuttleSpeedPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void btnDecreaseActionPerformed(ActionEvent e) {
        int i = this.slider.getValue();
        this.slider.setValue(i - 1);
    }

    void btnIncreaseActionPerformed(ActionEvent e) {
        int i = this.slider.getValue();
        this.slider.setValue(i + 1);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public IVCR getVcr() {
        return this.vcr;
    }

    void jbInit() throws Exception {
        this.label.setToolTipText("");
        this.label.setText("Speed: 000");
        this.btnDecrease.setPreferredSize(this.buttonSize);
        this.btnDecrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCRShuttleSpeedPanel.this.btnDecreaseActionPerformed(e);
            }
        });
        this.btnDecrease.setIcon(new ImageIcon(this.getClass().getResource("/images/vcr/minus.png")));
        this.btnDecrease.setPressedIcon(new ImageIcon(this.getClass().getResource("/images/vcr/minus_r.png")));
        this.btnIncrease.setPreferredSize(this.buttonSize);
        this.btnIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCRShuttleSpeedPanel.this.btnIncreaseActionPerformed(e);
            }
        });
        this.btnIncrease.setIcon(new ImageIcon(this.getClass().getResource("/images/vcr/plus.png")));
        this.btnIncrease.setPressedIcon(new ImageIcon(this.getClass().getResource("/images/vcr/plus_r.png")));
        this.slider.setMinorTickSpacing(5);
        this.slider.setMajorTickSpacing(25);
        this.slider.setValue(100);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VCRShuttleSpeedPanel.this.sliderPropertyChange(e);
            }
        });
        this.slider.setPaintTicks(true);
        this.slider.setMaximum(255);
        this.slider.setDoubleBuffered(true);
        this.slider.setPreferredSize(new Dimension(140, 40));
        this.slider.setToolTipText("");
        this.slider.setLabelTable(this.sliderLabels);
        this.setSliderLabel(this.slider.getValue());
        this.slider.setPaintLabels(true);
        FlowLayout layout = new FlowLayout(0);
        this.setLayout(layout);
        layout.setHgap(0);
        this.add((Component)this.btnDecrease, null);
        this.add((Component)this.slider, null);
        this.add((Component)this.btnIncrease, null);
    }

    private void setSliderLabel(int value) {
        if (this.sliderLabels.size() > 0) {
            this.sliderLabels.remove(this.currentLabelKey);
        }
        this.currentLabelKey = value;
        this.currentLabel.setText(this.currentLabelKey + "");
        this.sliderLabels.put(this.currentLabelKey, this.currentLabel);
    }

    public void setVcr(IVCR vcr) {
        this.vcr = vcr;
    }

    void sliderPropertyChange(ChangeEvent e) {
        IVCRState m;
        this.label.setText(this.slider.getValue() + "");
        this.setSliderLabel(this.slider.getValue());
        this.slider.repaint();
        if (this.vcr != null && !this.slider.getValueIsAdjusting() && (m = this.vcr.getVcrState()) != null && m.isShuttling()) {
            if (m.isReverseDirection()) {
                this.vcr.shuttleReverse(this.slider.getValue());
            } else {
                this.vcr.shuttleForward(this.slider.getValue());
            }
        }
    }
}

