/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javax.swing.Icon;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRShuttleButton;

public class VCRShuttleReverseButton
extends VCRShuttleButton {
    public VCRShuttleReverseButton(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        super(videoController);
        this.setOnIcon("/images/vcr/shuttleback_r.png");
        this.setOffIcon("/images/vcr/shuttleback.png");
        this.setToolTipText("Shuttle reverse");
    }

    @Override
    void onNext(VideoState videoState) {
        Icon icon = videoState.isShuttling() & videoState.isReverseDirection() ? this.onIcon : this.offIcon;
        this.setIcon(icon);
    }

    @Override
    void doAction() {
        Optional.ofNullable(this.videoControllerProperty().get()).ifPresent(vc -> vc.shuttle((double)this.slider.getValue() / -255.0));
    }
}

