/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javafx.beans.property.ObjectProperty;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.RXTXConnectionPanel;
import org.mbari.vcr4j.ui.swing.VCRConnectionPanel;

public class VCRSelectionPanel
extends JPanel {
    private VCRConnectionPanel currentConnectionPanel = null;
    private JRadioButton rs422RB = null;
    private ActionListener rs422RBListener = null;
    private JRadioButton udp01RB = null;
    private ActionListener udp01RBListener = null;
    private JRadioButton udp02RB = null;
    private ActionListener udp02RBListener = null;
    private VCRConnectionPanel vcrConnectionPanelRs422 = null;
    private VCRConnectionPanel vcrConnectionPanelUDP01 = null;
    private VCRConnectionPanel vcrConnectionPanelUDP02 = null;
    private JPanel vcrTypePanel = null;
    private final ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController;

    public VCRSelectionPanel(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        this.videoController = videoController;
        this.initialize();
    }

    private JRadioButton getRs422RB() {
        if (this.rs422RB == null) {
            this.rs422RB = new JRadioButton();
            this.rs422RB.setText(this.getVcrConnectionPanelRs422().getVcrPanelName());
            this.rs422RB.addActionListener(this.getRs422RBListener());
            this.rs422RB.setSelected(true);
        }
        return this.rs422RB;
    }

    private ActionListener getRs422RBListener() {
        if (this.rs422RBListener == null) {
            this.rs422RBListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VCRSelectionPanel.this.rs422RB.isSelected()) {
                        VCRSelectionPanel.this.setCurrentConnectionPanel(VCRSelectionPanel.this.getVcrConnectionPanelRs422());
                    }
                }
            };
        }
        return this.rs422RBListener;
    }

    public void connect() {
        this.currentConnectionPanel.connect();
    }

    private VCRConnectionPanel getVcrConnectionPanelRs422() {
        if (this.vcrConnectionPanelRs422 == null) {
            this.vcrConnectionPanelRs422 = new RXTXConnectionPanel(this.videoController);
        }
        return this.vcrConnectionPanelRs422;
    }

    private JPanel getVcrTypePanel() {
        if (this.vcrTypePanel == null) {
            this.vcrTypePanel = new JPanel();
            this.vcrTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Connection Type", 0, 0, null, null));
            this.vcrTypePanel.add((Component)this.getRs422RB(), null);
        }
        return this.vcrTypePanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getVcrTypePanel(), "North");
        this.add((Component)this.getVcrConnectionPanelRs422(), "Center");
        this.setCurrentConnectionPanel(this.getVcrConnectionPanelRs422());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getRs422RB());
    }

    private void setCurrentConnectionPanel(VCRConnectionPanel vcrConnectionPanel) {
        if (this.currentConnectionPanel != null) {
            this.remove(this.currentConnectionPanel);
        }
        this.currentConnectionPanel = vcrConnectionPanel;
        this.add((Component)this.currentConnectionPanel, "Center");
        this.revalidate();
        this.repaint();
    }
}

