/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javafx.beans.property.ObjectProperty;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRSelectionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRSelectionDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(VCRSelectionDialog.class);
    private JPanel buttonPanel = null;
    private JButton cancelButton = null;
    private JPanel jContentPane = null;
    private Action okAction = null;
    private JButton okButton = null;
    private VCRSelectionPanel vcrSelectionPanel = null;
    private final ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController;

    public VCRSelectionDialog(Frame owner, ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) throws HeadlessException {
        super(owner, true);
        this.videoController = videoController;
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getCancelButton(), null);
            this.buttonPanel.add((Component)this.getOkButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(e -> this.setVisible(false));
        }
        return this.cancelButton;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getVcrSelectionPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private Action getOkAction() {
        if (this.okAction == null) {
            this.okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug("Opening a dialog to select the VCR");
                    VCRSelectionDialog.this.setVisible(false);
                    VCRSelectionDialog.this.getVcrSelectionPanel().connect();
                    log.debug("Connection to VCR is now established");
                }
            };
            this.okAction.putValue("Name", "OK");
            this.okAction.putValue("ActionCommandKey", "OK");
            this.okAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
        }
        return this.okAction;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setAction(this.getOkAction());
            Action a = this.getOkAction();
            this.okButton.getActionMap().put(a.getValue("ActionCommandKey"), a);
            this.okButton.getInputMap(2).put((KeyStroke)a.getValue("AcceleratorKey"), a.getValue("ActionCommandKey"));
        }
        return this.okButton;
    }

    private VCRSelectionPanel getVcrSelectionPanel() {
        if (this.vcrSelectionPanel == null) {
            this.vcrSelectionPanel = new VCRSelectionPanel(this.videoController);
        }
        return this.vcrSelectionPanel;
    }

    private void initialize() {
        this.setSize(new Dimension(301, 205));
        this.setTitle("VARS - Connect to VCR");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }
}

