/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javax.swing.Icon;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.ui.swing.VCRButton;

public class VCRPauseButton
extends VCRButton {
    public VCRPauseButton(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        super(videoController);
        this.setOnIcon("/images/vcr/pause_r.png");
        this.setOffIcon("/images/vcr/pause.png");
        this.setToolTipText("Pause");
    }

    @Override
    void doAction() {
        Optional.ofNullable(this.videoControllerProperty().get()).ifPresent(vc -> vc.send((VideoCommand)VideoCommands.PAUSE));
    }

    @Override
    void onNext(VideoState videoState) {
        Icon icon = videoState.isStopped() ? this.onIcon : this.offIcon;
        this.setIcon(icon);
    }
}

