/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.TimeCodeField;
import org.mbari.vcr4j.ui.swing.VCRButtonPanel;
import org.mbari.vcr4j.ui.swing.VCRShuttleSpeedPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(VCRPanel.class);
    private VCRShuttleSpeedPanel sliderPanel;
    private JTextField timeCodeField;
    private JPanel timeCodePanel;
    private ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController = new SimpleObjectProperty();
    private VCRButtonPanel vcrButtonPanel;

    public VCRPanel() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        Optional.ofNullable(this.videoController.get()).ifPresent(vc -> vc.getVideoIO().close());
        this.getTimeCodeField().setText("NO VIDEO");
    }

    public void finalize() {
        try {
            super.finalize();
            Optional.ofNullable(this.videoControllerProperty().get()).ifPresent(vc -> vc.getVideoIO().close());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public VCRShuttleSpeedPanel getSliderPanel() {
        if (this.sliderPanel == null) {
            this.sliderPanel = new VCRShuttleSpeedPanel();
        }
        return this.sliderPanel;
    }

    JTextField getTimeCodeField() {
        if (this.timeCodeField == null) {
            this.timeCodeField = new TimeCodeField(this.videoController);
        }
        return this.timeCodeField;
    }

    JPanel getTimeCodePanel() {
        if (this.timeCodePanel == null) {
            this.timeCodePanel = new JPanel();
            this.timeCodePanel.setMinimumSize(new Dimension(180, 100));
            this.timeCodePanel.setPreferredSize(new Dimension(180, 100));
            this.timeCodePanel.add(this.getTimeCodeField());
            this.timeCodePanel.add(this.getSliderPanel());
        }
        return this.timeCodePanel;
    }

    public VideoIndex getVideoIndex() {
        VideoIndex videoIndex = null;
        if (this.videoController.get() != null) {
            CompletableFuture future = new CompletableFuture();
            ((VideoController)this.videoController.get()).getIndexObservable().take(1).forEach(future::complete);
            try {
                videoIndex = (VideoIndex)future.get(2L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return videoIndex;
    }

    VCRButtonPanel getVcrButtonPanel() {
        if (this.vcrButtonPanel == null) {
            this.vcrButtonPanel = new VCRButtonPanel(this.videoController);
            this.vcrButtonPanel.setSlider(this.getSliderPanel().getSlider());
        }
        return this.vcrButtonPanel;
    }

    private void initialize() throws Exception {
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(10);
        this.setLayout(layout);
        this.add(this.getTimeCodePanel());
        this.add(this.getVcrButtonPanel());
        this.videoController.addListener((obs, oldVal, newVal) -> {
            log.debug("Setting videoController to " + newVal);
            this.getTimeCodeField().setText("NO VIDEO");
            newVal.requestStatus();
        });
        this.getTimeCodeField().setText("NO VIDEO");
    }

    public VideoController<? extends VideoState, ? extends VideoError> getVideoController() {
        return (VideoController)this.videoController.get();
    }

    public ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoControllerProperty() {
        return this.videoController;
    }

    public void setVideoController(VideoController<? extends VideoState, ? extends VideoError> videoController) {
        this.videoController.set(videoController);
    }
}

