/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javafx.beans.property.ObjectProperty;
import javax.swing.Icon;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRButton;
import org.mbari.vcr4j.ui.swing.VCRGotoFrame;

public class VCRGotoButton
extends VCRButton {
    final VCRGotoFrame f = new VCRGotoFrame();
    private boolean firstShowing = true;

    public VCRGotoButton(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        super(videoController);
        this.setOnIcon("/images/vcr/goto_r.png");
        this.setOffIcon("/images/vcr/goto.png");
        this.setToolTipText("Go to a timecode");
        this.f.setResizable(false);
        this.f.pack();
    }

    @Override
    void onNext(VideoState videoState) {
        Icon icon = videoState.isCueingUp() ? this.onIcon : this.offIcon;
        this.setIcon(icon);
    }

    @Override
    void doAction() {
        if (this.videoControllerProperty().get() != null) {
            if (this.firstShowing) {
                int thisY = this.getY();
                Dimension fD = this.f.getSize();
                int fY = fD.height;
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int sY = screenSize.height;
                Point p = this.getLocationOnScreen();
                if ((double)(thisY + fY) + p.getY() > (double)sY) {
                    int newY = (int)p.getY() - fY;
                    int newX = (int)p.getX();
                    this.f.setLocation(newX, newY);
                } else {
                    this.f.setLocation(this.getLocationOnScreen());
                }
                this.firstShowing = false;
            }
            this.f.setVisible(true);
        }
    }
}

