/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRPanel;
import org.mbari.vcr4j.ui.swing.VCRSelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(VCRFrame.class);
    private Action connectAction = null;
    private JMenuItem connectMenuItem = null;
    private Action disconnectAction = null;
    private JMenuItem disconnectMenuItem = null;
    private Action exitAction = null;
    private JMenuItem exitMenuItem = null;
    private JMenu fileMenu = null;
    private JPanel jContentPane = null;
    private JMenuBar myMenuBar = null;
    private JMenu vcrMenu = null;
    private VCRPanel vcrPanel = null;
    private JDialog connectDialog = new VCRSelectionDialog((Frame)this, this.getVcrPanel().videoControllerProperty());

    public VCRFrame() {
        this.initialize();
    }

    private Action getConnectAction() {
        if (this.connectAction == null) {
            this.connectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    VCRFrame.this.connectDialog.setVisible(true);
                }
            };
            this.connectAction.putValue("Name", "Connect");
            this.connectAction.putValue("ActionCommandKey", "connect");
            this.connectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        return this.connectAction;
    }

    private JMenuItem getConnectMenuItem() {
        if (this.connectMenuItem == null) {
            this.connectMenuItem = new JMenuItem();
            this.connectMenuItem.setAction(this.getConnectAction());
        }
        return this.connectMenuItem;
    }

    private Action getDisconnectAction() {
        if (this.disconnectAction == null) {
            this.disconnectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    VCRFrame.this.getVcrPanel().disconnect();
                }
            };
            this.disconnectAction.putValue("Name", "Disconnect");
            this.disconnectAction.putValue("ActionCommandKey", "disconnect");
            this.disconnectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        return this.disconnectAction;
    }

    private JMenuItem getDisconnectMenuItem() {
        if (this.disconnectMenuItem == null) {
            this.disconnectMenuItem = new JMenuItem();
            this.disconnectMenuItem.setAction(this.getDisconnectAction());
        }
        return this.disconnectMenuItem;
    }

    private Action getExitAction() {
        if (this.exitAction == null) {
            this.exitAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    System.exit(0);
                }
            };
            this.exitAction.putValue("Name", "Exit");
            this.exitAction.putValue("ActionCommandKey", "exit");
            this.exitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        return this.exitAction;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setAction(this.getExitAction());
        }
        return this.exitMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getVcrPanel(), "Center");
            Action a = this.getExitAction();
            this.jContentPane.getActionMap().put(a.getValue("ActionCommandKey"), a);
            this.jContentPane.getInputMap(2).put((KeyStroke)a.getValue("AcceleratorKey"), a.getValue("ActionCommandKey"));
        }
        return this.jContentPane;
    }

    private JMenuBar getMyMenuBar() {
        if (this.myMenuBar == null) {
            this.myMenuBar = new JMenuBar();
            this.myMenuBar.add(this.getFileMenu());
            this.myMenuBar.add(this.getVcrMenu());
        }
        return this.myMenuBar;
    }

    private JMenu getVcrMenu() {
        if (this.vcrMenu == null) {
            this.vcrMenu = new JMenu();
            this.vcrMenu.setText("VCR");
            this.vcrMenu.add(this.getConnectMenuItem());
            this.vcrMenu.add(this.getDisconnectMenuItem());
        }
        return this.vcrMenu;
    }

    private VCRPanel getVcrPanel() {
        if (this.vcrPanel == null) {
            this.vcrPanel = new VCRPanel();
        }
        return this.vcrPanel;
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getMyMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("VCR Console");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
        this.setResizable(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.info("Unable to set look and feel", (Throwable)e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VCRFrame();
            }
        });
    }

    public void setVideoController(VideoController<? extends VideoState, ? extends VideoError> videoController) {
        this.getVcrPanel().setVideoController(videoController);
    }
}

