/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javax.swing.Icon;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRButton;

public class VCRFastForwardButton
extends VCRButton {
    public VCRFastForwardButton(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        super(videoController);
        this.setOnIcon("/images/vcr/ffwd_r.png");
        this.setOffIcon("/images/vcr/ffwd.png");
        this.setToolTipText("Fast Forward");
    }

    @Override
    void doAction() {
        Optional.ofNullable(this.videoControllerProperty().get()).ifPresent(VideoController::fastForward);
    }

    @Override
    void onNext(VideoState videoState) {
        Icon icon = videoState.isFastForwarding() ? this.onIcon : this.offIcon;
        this.setIcon(icon);
    }
}

