/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.commands.PresetUserbitsCmd;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.rs422.decorators.RS422LoggingDecorator;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rxtx.RXTXUtilities;
import org.mbari.vcr4j.rxtx.RXTXVideoIO;
import org.mbari.vcr4j.ui.swing.VCRConsoleFrame_AboutBox;
import org.mbari.vcr4j.ui.swing.VCRPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRConsoleFrame
extends JFrame {
    VCRPanel vcrPanel = new VCRPanel();
    JMenuItem menuHelpAbout = new JMenuItem();
    JMenu menuHelp = new JMenu();
    JMenuItem menuFileExit = new JMenuItem();
    JMenu menuFile = new JMenu();
    JMenuItem menuConnect = new JMenuItem();
    JMenuBar menuBar = new JMenuBar();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel contentPane;
    UserbitPanel statusBar;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public VCRConsoleFrame() {
        this.enableEvents(64L);
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected UserbitPanel getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new UserbitPanel();
        }
        return this.statusBar;
    }

    private void initialize() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(350, 165));
        this.setTitle("VCR Console");
        this.menuFile.setText("File");
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(this::menuFileExitActionPerformed);
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        this.menuHelpAbout.addActionListener(this::menuHelpAboutActionPerformed);
        this.menuConnect.setText("Connect to VCR");
        this.menuConnect.addActionListener(e -> {
            HashSet ports = RXTXUtilities.getAvailableSerialPorts();
            Object[] portNames = (String[])ports.stream().map(CommPortIdentifier::getName).sorted().toArray(String[]::new);
            if (portNames.length == 0) {
                JOptionPane.showMessageDialog(this, "No serial ports were found. Unable to connect to a VCR.", "Error", 0);
                return;
            }
            String s = (String)JOptionPane.showInputDialog(this, "Select a serial port", "VCR Serial Port", -1, null, portNames, portNames[0]);
            if (s != null && s.length() > 0) {
                try {
                    this.log.debug("Opening " + s);
                    RXTXVideoIO io = RXTXVideoIO.open((String)s);
                    VCRSyncDecorator syncDecorator = new VCRSyncDecorator((VideoIO)io);
                    RS422StatusDecorator statusDecorator = new RS422StatusDecorator((VCRVideoIO)io);
                    RS422LoggingDecorator loggingDecorator = new RS422LoggingDecorator((VCRVideoIO)io);
                    this.vcrPanel.setVideoController((VideoController<? extends VideoState, ? extends VideoError>)new VideoController((VideoIO)io));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.menuFile.add(this.menuConnect);
        this.menuFile.add(this.menuFileExit);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.contentPane.add((Component)this.getStatusBar(), "South");
        this.contentPane.add((Component)this.vcrPanel, "Center");
    }

    public void menuFileExitActionPerformed(ActionEvent e) {
        this.vcrPanel.disconnect();
        System.exit(0);
    }

    public void menuHelpAboutActionPerformed(ActionEvent e) {
        VCRConsoleFrame_AboutBox dlg = new VCRConsoleFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.menuFileExitActionPerformed(null);
        }
    }

    class UserbitPanel
    extends JPanel {
        private JButton button;
        private UserbitLabel label;
        private JButton setButton;

        UserbitPanel() {
            this.initialize();
        }

        JButton getButton() {
            if (this.button == null) {
                this.button = new JButton();
                this.button.setText("Get User-bits");
                this.button.addActionListener(e -> Optional.ofNullable(VCRConsoleFrame.this.vcrPanel.videoControllerProperty().get()).ifPresent(vc -> vc.send((VideoCommand)RS422VideoCommands.REQUEST_USERBITS)));
            }
            return this.button;
        }

        UserbitLabel getLabel() {
            if (this.label == null) {
                this.label = new UserbitLabel();
                this.label.setText(" ");
            }
            return this.label;
        }

        JButton getSetButton() {
            if (this.setButton == null) {
                this.setButton = new JButton();
                this.setButton.setText("Set User-bits");
                this.setButton.addActionListener(e -> Optional.ofNullable(VCRConsoleFrame.this.vcrPanel.videoControllerProperty().get()).ifPresent(vc -> vc.send((VideoCommand)new PresetUserbitsCmd(new byte[]{1, 2, 3, 4}))));
            }
            return this.setButton;
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getButton(), "West");
            this.add((Component)this.getLabel(), "Center");
            this.add((Component)this.getSetButton(), "East");
        }
    }

    class UserbitLabel
    extends JLabel {
        public UserbitLabel() {
            VCRConsoleFrame.this.vcrPanel.videoControllerProperty().addListener((obs, oldVal, newVal) -> {
                this.setText("");
                if (newVal != null && newVal instanceof VCRVideoIO) {
                    VCRVideoIO io = (VCRVideoIO)newVal;
                    io.getUserbitsObservable().subscribe(ub -> {
                        byte[] b = ub.getUserbits();
                        BigInteger bi = new BigInteger(b);
                        String bs = bi.toString(16);
                        if (bs.length() % 2 != 0) {
                            bs = "0" + bs;
                        }
                        this.setText(bs);
                    });
                }
            });
        }
    }
}

