/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javafx.beans.property.ObjectProperty;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.ui.swing.VCRButton;
import org.mbari.vcr4j.ui.swing.VCREjectButton;
import org.mbari.vcr4j.ui.swing.VCRFastForwardButton;
import org.mbari.vcr4j.ui.swing.VCRGotoButton;
import org.mbari.vcr4j.ui.swing.VCRPlayButton;
import org.mbari.vcr4j.ui.swing.VCRRewindButton;
import org.mbari.vcr4j.ui.swing.VCRShuttleButton;
import org.mbari.vcr4j.ui.swing.VCRShuttleForwardButton;
import org.mbari.vcr4j.ui.swing.VCRShuttleReverseButton;
import org.mbari.vcr4j.ui.swing.VCRStopButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRButtonPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(VCRButtonPanel.class);
    final VCRButton btnPlay;
    final VCRButton btnStop;
    final VCRShuttleButton btnShuttleReverse;
    final VCRShuttleButton btnShuttleForward;
    final VCRButton btnRewind;
    final VCRButton btnGoto;
    final VCRButton btnFastForward;
    final VCRButton btnEject;
    final GridLayout layout = new GridLayout(2, 4, 1, 1);
    private JSlider slider;
    private final ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController;

    public VCRButtonPanel(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        this.videoController = videoController;
        this.btnEject = new VCREjectButton(videoController);
        this.btnFastForward = new VCRFastForwardButton(videoController);
        this.btnGoto = new VCRGotoButton(videoController);
        this.btnPlay = new VCRPlayButton(videoController);
        this.btnRewind = new VCRRewindButton(videoController);
        this.btnShuttleForward = new VCRShuttleForwardButton(videoController);
        this.btnShuttleReverse = new VCRShuttleReverseButton(videoController);
        this.btnStop = new VCRStopButton(videoController);
        videoController.addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                newVal.requestStatus();
            }
        });
        try {
            this.initialize();
        }
        catch (Exception ex) {
            log.error("Failed to initialize", (Throwable)ex);
        }
    }

    public JSlider getSlider() {
        return this.slider;
    }

    void initialize() throws Exception {
        this.setLayout(this.layout);
        this.layout.setHgap(0);
        this.btnGoto.setMinimumSize(new Dimension(35, 35));
        this.btnFastForward.setMinimumSize(new Dimension(35, 35));
        this.btnRewind.setMinimumSize(new Dimension(35, 35));
        this.btnEject.setMinimumSize(new Dimension(35, 35));
        this.btnStop.setMinimumSize(new Dimension(35, 35));
        this.btnPlay.setMinimumSize(new Dimension(35, 35));
        this.btnShuttleForward.setMinimumSize(new Dimension(35, 35));
        this.btnShuttleReverse.setMinimumSize(new Dimension(35, 35));
        this.add((Component)((Object)this.btnGoto));
        this.add((Component)((Object)this.btnShuttleReverse));
        this.add((Component)((Object)this.btnPlay));
        this.add((Component)((Object)this.btnShuttleForward));
        this.add((Component)((Object)this.btnEject));
        this.add((Component)((Object)this.btnRewind));
        this.add((Component)((Object)this.btnStop));
        this.add((Component)((Object)this.btnFastForward));
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
        this.btnShuttleForward.setSlider(slider);
        this.btnShuttleReverse.setSlider(slider);
    }
}

