/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Color;
import javafx.beans.property.ObjectProperty;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.CompoundBorder;
import org.mbari.swing.JFancyButton;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import rx.Subscriber;

public abstract class VCRButton
extends JFancyButton {
    private volatile Subscriber<VideoState> subscriber;
    Icon offIcon;
    Icon onIcon;
    private final ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController;

    public VCRButton(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        this.videoController = videoController;
        this.addActionListener(e -> this.doAction());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.ORANGE, Color.GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBorder(border);
        videoController.addListener((obs, oldVal, newVal) -> {
            if (oldVal != null && this.subscriber != null) {
                this.subscriber.unsubscribe();
                this.subscriber = null;
            }
            if (newVal != null) {
                this.subscriber = this.newSubscriber();
                newVal.getStateObservable().subscribe(this.subscriber);
            }
        });
    }

    public void setOffIcon(String relativePath) {
        this.offIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource(relativePath));
        this.setIcon(this.offIcon);
    }

    public void setOnIcon(String relativePath) {
        this.onIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource(relativePath));
        this.setPressedIcon(this.onIcon);
    }

    abstract void doAction();

    abstract void onNext(VideoState var1);

    public ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoControllerProperty() {
        return this.videoController;
    }

    private Subscriber<VideoState> newSubscriber() {
        return new Subscriber<VideoState>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(VideoState videoState) {
                VCRButton.this.onNext(videoState);
            }
        };
    }
}

