/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mbari.vcr4j.rxtx.RXTX;
import org.mbari.vcr4j.ui.swing.VCRConsoleFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRApp {
    private static final Logger log = LoggerFactory.getLogger(VCRApp.class);
    private JFrame frame;

    public VCRApp() {
        this.initialize();
    }

    protected JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new VCRConsoleFrame();
        }
        return this.frame;
    }

    private void initialize() {
        JFrame f = this.getFrame();
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = f.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        f.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        f.setVisible(true);
    }

    public static void main(String[] args) {
        RXTX.setup();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.info("Unable to set look and feel", (Throwable)e);
        }
        SwingUtilities.invokeLater(VCRApp::new);
    }
}

