/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mbari.awt.layout.VerticalFlowLayout;

public class TimeSlider
extends JPanel {
    final VerticalFlowLayout layout = new VerticalFlowLayout();
    int maxValue;
    JSlider slider;
    JTextField textField;

    public TimeSlider(int maxValue) {
        this.maxValue = maxValue;
        this.initialize();
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setOrientation(1);
            this.slider.setInverted(true);
            this.slider.setMajorTickSpacing(10);
            this.slider.setMaximum(this.maxValue);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
            this.slider.setPreferredSize(new Dimension(43, 230));
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    String text;
                    String v = TimeSlider.this.slider.getValue() + "";
                    if (!v.equals(text = TimeSlider.this.getTextField().getText())) {
                        TimeSlider.this.getTextField().setText(TimeSlider.this.slider.getValue() + "");
                        TimeSlider.this.getTextField().requestFocus();
                    }
                }
            });
            this.slider.setValue(0);
            this.slider.setPreferredSize(new Dimension(38, this.maxValue * 3));
            this.slider.setRequestFocusEnabled(false);
            this.slider.setFocusable(false);
        }
        return this.slider;
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setBackground(Color.black);
            this.textField.setFont(new Font("Dialog", 1, 16));
            this.textField.setForeground(Color.red);
            this.textField.setPreferredSize(new Dimension(38, 25));
            this.textField.setSelectedTextColor(Color.red);
            this.textField.setText("");
            this.textField.setHorizontalAlignment(4);
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeSlider.this.slider.setValue(Integer.parseInt(TimeSlider.this.textField.getText()));
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (c != '\n' && !Character.isDigit(c) && c != '\b' && c != '\u007f') {
                        TimeSlider.this.getToolkit().beep();
                        e.consume();
                    }
                }
            });
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    TimeSlider.this.textField.setSelectionStart(0);
                    TimeSlider.this.textField.setSelectionEnd(TimeSlider.this.textField.getText().length());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    int value = 0;
                    try {
                        value = Integer.parseInt(TimeSlider.this.textField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    TimeSlider.this.setTime(value);
                }
            });
        }
        return this.textField;
    }

    public int getTime() {
        return this.slider.getValue();
    }

    void initialize() {
        this.setLayout((LayoutManager)this.layout);
        this.setPreferredSize(new Dimension(45, 230));
        this.add((Component)this.getTextField(), null);
        this.add((Component)this.getSlider(), null);
    }

    public void setTime(int value) {
        JSlider s = this.getSlider();
        int min = s.getMinimum();
        int max = s.getMaximum();
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        if (s.getValue() != value) {
            s.setValue(value);
        }
    }
}

