/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.mbari.vcr4j.time.Converters;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.time.Timecode;
import org.mbari.vcr4j.ui.swing.TimeSlider;

public class TimeSelectPanel
extends JPanel {
    private TimeSlider frameWidget;
    private TimeSlider hourWidget;
    private TimeSlider minuteWidget;
    private NumberFormat numberFormat;
    private TimeSlider secondWidget;

    public TimeSelectPanel() {
        this.initialize();
    }

    public int getFrame() {
        return this.getFrameWidget().getTime();
    }

    public TimeSlider getFrameWidget() {
        if (this.frameWidget == null) {
            this.frameWidget = new TimeSlider(30);
        }
        return this.frameWidget;
    }

    public int getHour() {
        return this.getHourWidget().getTime();
    }

    public TimeSlider getHourWidget() {
        if (this.hourWidget == null) {
            this.hourWidget = new TimeSlider(24);
            JTextField tf = this.hourWidget.getTextField();
            Document d = tf.getDocument();
            d.addDocumentListener(this.makeDocumentListener(this.getMinuteWidget().getTextField()));
        }
        return this.hourWidget;
    }

    public int getMinute() {
        return this.getMinuteWidget().getTime();
    }

    public TimeSlider getMinuteWidget() {
        if (this.minuteWidget == null) {
            this.minuteWidget = new TimeSlider(59);
            JTextField tf = this.minuteWidget.getTextField();
            Document d = tf.getDocument();
            d.addDocumentListener(this.makeDocumentListener(this.getSecondWidget().getTextField()));
        }
        return this.minuteWidget;
    }

    private NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat();
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumIntegerDigits(2);
        }
        return this.numberFormat;
    }

    public int getSecond() {
        return this.getSecondWidget().getTime();
    }

    public TimeSlider getSecondWidget() {
        if (this.secondWidget == null) {
            this.secondWidget = new TimeSlider(59);
            JTextField tf = this.secondWidget.getTextField();
            Document d = tf.getDocument();
            d.addDocumentListener(this.makeDocumentListener(this.getFrameWidget().getTextField()));
        }
        return this.secondWidget;
    }

    public String getTimeAsString() {
        StringBuffer sb = new StringBuffer();
        NumberFormat nf = this.getNumberFormat();
        sb.append(nf.format(this.getHour())).append(":");
        sb.append(nf.format(this.getMinute())).append(":");
        sb.append(nf.format(this.getSecond())).append(":");
        sb.append(nf.format(this.getFrame()));
        return sb.toString();
    }

    public Timecode getTimecode() {
        HMSF hmsf = new HMSF(this.getHour(), this.getMinute(), this.getSecond(), this.getFrame());
        Timecode timecode = Converters.toTimecode((HMSF)hmsf);
        return timecode;
    }

    void initialize() {
        this.add(this.getHourWidget());
        this.add(this.getMinuteWidget());
        this.add(this.getSecondWidget());
        this.add(this.getFrameWidget());
    }

    public DocumentListener makeDocumentListener(final JComponent target) {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            void update(DocumentEvent e) {
                if (e.getDocument().getLength() >= 2) {
                    target.requestFocus();
                }
            }
        };
    }
}

