/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javafx.beans.property.ObjectProperty;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.time.Timecode;
import rx.Subscriber;

public class TimeCodeField
extends JTextField {
    private volatile Subscriber<VideoIndex> subscriber;
    private Dimension size = new Dimension(180, 40);

    public TimeCodeField(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        this.initComponent();
        videoController.addListener((obs, oldVal, newVal) -> {
            if (oldVal != null && this.subscriber != null) {
                this.subscriber.unsubscribe();
                this.subscriber = null;
            }
            if (newVal != null) {
                this.subscriber = this.newSubscriber();
                newVal.getIndexObservable().filter(vi -> vi.getTimecode().isPresent()).subscribe(this.subscriber);
            }
        });
    }

    private void initComponent() {
        this.setBackground(Color.black);
        this.setFont(new Font("SansSerif", 1, 26));
        this.setForeground(Color.red);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(this.size);
        this.setRequestFocusEnabled(false);
        this.setCaretColor(Color.black);
        this.setDisabledTextColor(Color.black);
        this.setEditable(false);
        this.setHorizontalAlignment(0);
        this.setSelectedTextColor(Color.red);
        this.setSelectionColor(Color.black);
        this.setColumns(9);
        this.setAlignmentX(0.5f);
    }

    private Subscriber<VideoIndex> newSubscriber() {
        return new Subscriber<VideoIndex>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(VideoIndex videoIndex) {
                String txt = videoIndex.getTimecode().map(Timecode::toString).orElse("--:--:--:--");
                TimeCodeField.this.setText(txt);
            }
        };
    }
}

