/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.ui.swing;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import javafx.beans.property.ObjectProperty;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rxtx.RXTXUtilities;
import org.mbari.vcr4j.rxtx.RXTXVideoIO;
import org.mbari.vcr4j.ui.swing.VCRConnectionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXTXConnectionPanel
extends VCRConnectionPanel {
    public static final String VCR_PANEL_NAME = "Direct (RS422)";
    private static final Logger log = LoggerFactory.getLogger(VCRConnectionPanel.class);
    private JLabel lbl1 = null;
    private JComboBox vcrListCB = null;

    public RXTXConnectionPanel(ObjectProperty<VideoController<? extends VideoState, ? extends VideoError>> videoController) {
        super(videoController);
        this.initialize();
    }

    @Override
    public void connect() {
        block2: {
            try {
                String port = (String)this.getVcrListCB().getSelectedItem();
                log.debug("Attempting to connect to " + port);
                RXTXVideoIO io = RXTXVideoIO.open((String)port);
                VCRSyncDecorator syncDecorator = new VCRSyncDecorator((VideoIO)io);
                RS422StatusDecorator statusDecorator = new RS422StatusDecorator((VCRVideoIO)io);
                this.videoControllerProperty().set((Object)new VideoController((VideoIO)io));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Failed to connect to VCR on port " + this.getVcrListCB().getSelectedItem(), (Throwable)e);
            }
        }
    }

    private JComboBox getVcrListCB() {
        if (this.vcrListCB == null) {
            this.vcrListCB = new JComboBox();
            HashSet ports = RXTXUtilities.getAvailableSerialPorts();
            this.vcrListCB.setPreferredSize(new Dimension(200, 25));
            for (CommPortIdentifier cpi : ports) {
                this.vcrListCB.addItem(cpi.getName());
            }
        }
        return this.vcrListCB;
    }

    @Override
    public String getVcrPanelName() {
        return VCR_PANEL_NAME;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 6, 0, 6);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(250, 60));
        this.lbl1 = new JLabel();
        this.lbl1.setText("Serial Port:");
        this.add((Component)this.lbl1, gridBagConstraints);
        this.add((Component)this.getVcrListCB(), gridBagConstraints1);
    }
}

