/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.internal.schedulers.GenericScheduledExecutorService;
import rx.internal.schedulers.SchedulerLifecycle;
import rx.internal.util.RxJavaPluginUtils;
import rx.internal.util.unsafe.MpmcArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public abstract class ObjectPool<T>
implements SchedulerLifecycle {
    Queue<T> pool;
    final int minSize;
    final int maxSize;
    private final long validationInterval;
    private final AtomicReference<Future<?>> periodicTask;

    public ObjectPool() {
        this(0, 0, 67L);
    }

    private ObjectPool(int min2, int max2, long validationInterval) {
        this.minSize = min2;
        this.maxSize = max2;
        this.validationInterval = validationInterval;
        this.periodicTask = new AtomicReference();
        this.initialize(min2);
        this.start();
    }

    public T borrowObject() {
        T object = this.pool.poll();
        if (object == null) {
            object = this.createObject();
        }
        return object;
    }

    public void returnObject(T object) {
        if (object == null) {
            return;
        }
        this.pool.offer(object);
    }

    @Override
    public void shutdown() {
        Future f = this.periodicTask.getAndSet(null);
        if (f != null) {
            f.cancel(false);
        }
    }

    @Override
    public void start() {
        while (true) {
            ScheduledFuture<?> f;
            if (this.periodicTask.get() != null) {
                return;
            }
            ScheduledExecutorService w = GenericScheduledExecutorService.getInstance();
            try {
                f = w.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            int size2;
                            block2: {
                                size2 = ObjectPool.this.pool.size();
                                if (size2 >= ObjectPool.this.minSize) break block2;
                                int sizeToBeAdded = ObjectPool.this.maxSize - size2;
                                for (int i = 0; i < sizeToBeAdded; ++i) {
                                    ObjectPool.this.pool.add(ObjectPool.this.createObject());
                                }
                                break block3;
                            }
                            if (size2 <= ObjectPool.this.maxSize) break block3;
                            int sizeToBeRemoved = size2 - ObjectPool.this.maxSize;
                            for (int i = 0; i < sizeToBeRemoved; ++i) {
                                ObjectPool.this.pool.poll();
                            }
                        }
                    }
                }, this.validationInterval, this.validationInterval, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException ex) {
                RxJavaPluginUtils.handleException(ex);
                break;
            }
            if (this.periodicTask.compareAndSet(null, f)) break;
            f.cancel(false);
        }
    }

    protected abstract T createObject();

    private void initialize(int min2) {
        this.pool = UnsafeAccess.isUnsafeAvailable() ? new MpmcArrayQueue<T>(Math.max(this.maxSize, 1024)) : new ConcurrentLinkedQueue<T>();
        for (int i = 0; i < min2; ++i) {
            this.pool.add(this.createObject());
        }
    }
}

