/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import rx.exceptions.CompositeException;

public enum ExceptionsUtils {

    private static final Throwable TERMINATED = new Throwable("Terminated");

    public static boolean addThrowable(AtomicReference<Throwable> field2, Throwable error) {
        Throwable next2;
        Throwable current;
        do {
            if ((current = field2.get()) == TERMINATED) {
                return false;
            }
            if (current == null) {
                next2 = error;
                continue;
            }
            if (current instanceof CompositeException) {
                ArrayList<Throwable> list = new ArrayList<Throwable>(((CompositeException)current).getExceptions());
                list.add(error);
                next2 = new CompositeException(list);
                continue;
            }
            next2 = new CompositeException(current, error);
        } while (!field2.compareAndSet(current, next2));
        return true;
    }

    public static Throwable terminate(AtomicReference<Throwable> field2) {
        Throwable current = field2.get();
        if (current != TERMINATED) {
            current = field2.getAndSet(TERMINATED);
        }
        return current;
    }

    public static boolean isTerminated(AtomicReference<Throwable> field2) {
        return ExceptionsUtils.isTerminated(field2.get());
    }

    public static boolean isTerminated(Throwable error) {
        return error == TERMINATED;
    }
}

