/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.observers.SerializedSubscriber;

public final class OperatorSampleWithObservable<T, U>
implements Observable.Operator<T, T> {
    final Observable<U> sampler;
    static final Object EMPTY_TOKEN = new Object();

    public OperatorSampleWithObservable(Observable<U> sampler) {
        this.sampler = sampler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s2 = new SerializedSubscriber<T>(child);
        final AtomicReference<Object> value = new AtomicReference<Object>(EMPTY_TOKEN);
        final AtomicReference<2> main2 = new AtomicReference<2>();
        final Subscriber samplerSub = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                Object localValue = value.getAndSet(EMPTY_TOKEN);
                if (localValue != EMPTY_TOKEN) {
                    Object v = localValue;
                    s2.onNext(v);
                }
            }

            @Override
            public void onError(Throwable e) {
                s2.onError(e);
                ((Subscription)main2.get()).unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.onNext((U)null);
                s2.onCompleted();
                ((Subscription)main2.get()).unsubscribe();
            }
        };
        Subscriber result2 = new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                value.set(t);
            }

            @Override
            public void onError(Throwable e) {
                s2.onError(e);
                samplerSub.unsubscribe();
            }

            @Override
            public void onCompleted() {
                samplerSub.onNext(null);
                s2.onCompleted();
                samplerSub.unsubscribe();
            }
        };
        main2.lazySet(result2);
        child.add(result2);
        child.add(samplerSub);
        this.sampler.unsafeSubscribe(samplerSub);
        return result2;
    }
}

