/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageWithCrossHairPanel
extends JPanel {
    private Shape crossHair;
    private BufferedImage image;

    public ImageWithCrossHairPanel() {
        this.initialize();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected void initialize() {
        this.addMouseMotionListener(new CrossHairMouseMotionListener());
        this.setBackground(Color.BLACK);
    }

    public static void main(String[] args) throws IOException {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        URL url = f.getClass().getResource("/images/BrianSchlining.jpg");
        BufferedImage image = ImageIO.read(url);
        ImageWithCrossHairPanel p = new ImageWithCrossHairPanel();
        p.setImage(image);
        f.setLayout(new BorderLayout());
        f.add((Component)p, "Center");
        f.setSize(image.getWidth(), image.getHeight());
        f.setVisible(true);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.image != null) {
            g2.drawImage(this.image, null, this);
        } else {
            g2.setPaint(Color.BLACK);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.setXORMode(Color.WHITE);
        if (this.crossHair != null) {
            g2.draw(this.crossHair);
        }
        g2.setPaintMode();
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    private class CrossHairMouseMotionListener
    implements MouseMotionListener {
        private CrossHairMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (ImageWithCrossHairPanel.this.image != null) {
                int x = e.getX();
                int y = e.getY();
                int w = ImageWithCrossHairPanel.this.image.getWidth();
                int h = ImageWithCrossHairPanel.this.image.getHeight();
                GeneralPath gp = new GeneralPath();
                if (y <= h) {
                    gp.moveTo(0.0f, y);
                    gp.lineTo(w, y);
                }
                if (x <= w) {
                    gp.moveTo(x, 0.0f);
                    gp.lineTo(x, h);
                }
                ImageWithCrossHairPanel.this.crossHair = gp;
                ImageWithCrossHairPanel.this.repaint(x, 0, 3, h);
                ImageWithCrossHairPanel.this.repaint(0, y, w, 3);
            }
        }
    }
}

